/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.tools.BlockPosList;
import de.maxhenkel.tools.EnergyUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityCable
extends TileEntityBase
implements ITickable,
IEnergyStorage {
    private final int transferRate;

    public TileEntityCable(int transferRate) {
        this.transferRate = transferRate;
    }

    public TileEntityCable() {
        this(Config.cableTransferRate);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int energy = 0;
        ArrayList<IEnergyStorage> providers = new ArrayList<IEnergyStorage>();
        for (EnumFacing facing : EnumFacing.values()) {
            IEnergyStorage provider = EnergyUtil.getEnergyStorage((IBlockAccess)this.field_145850_b, this.field_174879_c, facing);
            if (provider == null || provider instanceof TileEntityCable) continue;
            int cex = Math.max(0, this.transferRate - energy);
            if (cex <= 0) break;
            int extract = provider.extractEnergy(cex, true);
            if (extract <= 0) continue;
            energy += extract;
            providers.add(provider);
        }
        if (energy <= 0) {
            return;
        }
        ArrayList<IEnergyStorage> receivers = new ArrayList<IEnergyStorage>();
        this.getConnectedReceivers(providers, receivers, new BlockPosList(), this.field_174879_c);
        if (receivers.size() <= 0) {
            return;
        }
        int split = energy / receivers.size();
        if (split <= 0) {
            return;
        }
        int received = 0;
        for (IEnergyStorage entry : receivers) {
            received += entry.receiveEnergy(split, false);
        }
        for (IEnergyStorage entry : providers) {
            if (received <= 0) break;
            received -= entry.extractEnergy(received, false);
        }
    }

    public void getConnectedReceivers(List<IEnergyStorage> sources, List<IEnergyStorage> receivers, BlockPosList positions, BlockPos pos) {
        for (EnumFacing side : EnumFacing.values()) {
            BlockPos p = pos.func_177972_a(side);
            if (positions.contains(p)) continue;
            IBlockState state = this.field_145850_b.func_180495_p(p);
            if (state.func_177230_c().equals((Object)ModBlocks.CABLE)) {
                positions.add(p);
                this.getConnectedReceivers(sources, receivers, positions, p);
                continue;
            }
            IEnergyStorage storage = EnergyUtil.getEnergyStorage((IBlockAccess)this.field_145850_b, pos, side);
            if (storage == null || storage.equals((Object)this) || sources.contains(storage) || receivers.contains(storage)) continue;
            receivers.add(storage);
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }
}

