/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Config;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.fluids.ModFluids;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityBackmixReactor
extends TileEntityBase
implements ITickable,
IFluidHandler,
IEnergyStorage,
IInventory {
    public final int maxStorage = Config.backmixReactorEnergyStorage;
    protected int storedEnergy = 0;
    public final int energyUsage = Config.backmixReactorEnergyUsage;
    public final int methanolUsage;
    public final int maxMethanol = Config.backmixReactorFluidStorage;
    protected int currentMethanol = 0;
    public final int canolaUsage;
    public final int maxCanola = Config.backmixReactorFluidStorage;
    protected int currentCanola = 0;
    public final int maxMix = Config.backmixReactorFluidStorage;
    protected int currentMix = 0;
    public final int mixGeneration;
    public final int generatingTime = Config.backmixReactorGeneratingTime;
    protected int timeToGenerate = 0;

    public TileEntityBackmixReactor() {
        this.mixGeneration = Config.backmixReactorMixGeneration;
        this.methanolUsage = Config.backmixReactorMethanolUsage;
        this.canolaUsage = Config.backmixReactorCanolaUsage;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isEnabled()) {
            this.setBlockEnabled(true);
        } else {
            this.setBlockEnabled(false);
        }
        if (this.timeToGenerate > 0 && this.storedEnergy >= this.energyUsage) {
            this.storedEnergy -= this.energyUsage;
            --this.timeToGenerate;
            if (this.timeToGenerate == 0 && this.currentMix + this.mixGeneration <= this.maxMix) {
                this.currentMix += this.mixGeneration;
                this.currentCanola -= this.canolaUsage;
                this.currentMethanol -= this.methanolUsage;
            }
        } else if (this.storedEnergy >= this.energyUsage && this.currentCanola >= this.canolaUsage && this.currentMethanol >= this.methanolUsage && this.currentMix + this.mixGeneration <= this.maxMix) {
            this.timeToGenerate = this.generatingTime;
        }
        this.func_70296_d();
    }

    public boolean isEnabled() {
        return this.storedEnergy > 0 && this.currentMix < this.maxMix && this.currentMethanol >= this.methanolUsage && this.currentCanola >= this.canolaUsage;
    }

    public void setBlockEnabled(boolean enabled) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c().equals((Object)ModBlocks.BACKMIX_REACTOR)) {
            ModBlocks.BACKMIX_REACTOR.setPowered(this.field_145850_b, this.field_174879_c, state, enabled);
        }
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.storedEnergy;
            }
            case 1: {
                return this.currentCanola;
            }
            case 2: {
                return this.currentMethanol;
            }
            case 3: {
                return this.currentMix;
            }
            case 4: {
                return this.timeToGenerate;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.storedEnergy = value;
                break;
            }
            case 1: {
                this.currentCanola = value;
                break;
            }
            case 2: {
                this.currentMethanol = value;
                break;
            }
            case 3: {
                this.currentMix = value;
                break;
            }
            case 4: {
                this.timeToGenerate = value;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("stored_endergy", this.storedEnergy);
        compound.func_74768_a("canola", this.currentCanola);
        compound.func_74768_a("methanol", this.currentMethanol);
        compound.func_74768_a("mix", this.currentMix);
        compound.func_74768_a("time", this.timeToGenerate);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.storedEnergy = compound.func_74762_e("stored_endergy");
        this.currentCanola = compound.func_74762_e("canola");
        this.currentMethanol = compound.func_74762_e("methanol");
        this.currentMix = compound.func_74762_e("mix");
        this.timeToGenerate = compound.func_74762_e("time");
        super.func_145839_a(compound);
    }

    public int func_174890_g() {
        return 5;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new IFluidTankProperties(){

            public FluidStack getContents() {
                return new FluidStack((Fluid)ModFluids.CANOLA_OIL, TileEntityBackmixReactor.this.currentCanola);
            }

            public int getCapacity() {
                return TileEntityBackmixReactor.this.maxCanola;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return fluidStack.getFluid().equals((Object)ModFluids.CANOLA_OIL);
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrain() {
                return false;
            }
        }, new IFluidTankProperties(){

            public FluidStack getContents() {
                return new FluidStack((Fluid)ModFluids.METHANOL, TileEntityBackmixReactor.this.currentMethanol);
            }

            public int getCapacity() {
                return TileEntityBackmixReactor.this.maxMethanol;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return fluidStack.getFluid().equals((Object)ModFluids.METHANOL);
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrain() {
                return false;
            }
        }, new IFluidTankProperties(){

            public FluidStack getContents() {
                return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, TileEntityBackmixReactor.this.currentMix);
            }

            public int getCapacity() {
                return TileEntityBackmixReactor.this.maxMix;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return fluidStack.getFluid().equals((Object)ModFluids.CANOLA_METHANOL_MIX);
            }

            public boolean canDrain() {
                return true;
            }
        }};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid().equals((Object)ModFluids.METHANOL)) {
            int amount = Math.min(this.maxMethanol - this.currentMethanol, resource.amount);
            if (doFill) {
                this.currentMethanol += amount;
                this.func_70296_d();
            }
            return amount;
        }
        if (resource.getFluid().equals((Object)ModFluids.CANOLA_OIL)) {
            int amount = Math.min(this.maxCanola - this.currentCanola, resource.amount);
            if (doFill) {
                this.currentCanola += amount;
                this.func_70296_d();
            }
            return amount;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        int amount = Math.min(resource.amount, this.currentMix);
        if (doDrain) {
            this.currentMix -= amount;
            this.func_70296_d();
        }
        return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, amount);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        int amount = Math.min(maxDrain, this.currentMix);
        if (doDrain) {
            this.currentMix -= amount;
            this.func_70296_d();
        }
        return new FluidStack((Fluid)ModFluids.CANOLA_METHANOL_MIX, amount);
    }

    public String func_70005_c_() {
        return new TextComponentTranslation("tile.backmix_reactor.name", new Object[0]).func_150254_d();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int index) {
        return null;
    }

    public ItemStack func_70298_a(int index, int count) {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        return true;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyNeeded = this.maxStorage - this.storedEnergy;
        if (!simulate) {
            this.storedEnergy += Math.min(energyNeeded, maxReceive);
            this.func_70296_d();
        }
        return Math.min(energyNeeded, maxReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

