/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockCrop
extends BlockCrops {
    public static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockCrop(String name) {
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(0)));
    }

    protected abstract Item func_149866_i();

    protected abstract Item func_149865_P();

    public PropertyInteger func_185524_e() {
        return PropertyInteger.func_177719_a((String)"age", (int)0, (int)this.func_185526_g());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int age = this.func_185527_x(state);
        if (age >= CROPS_AABB.length) {
            return CROPS_AABB[CROPS_AABB.length - 1];
        }
        return CROPS_AABB[age];
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i;
        if (worldIn.func_175671_l(pos.func_177984_a()) >= this.getMinLightLevel() && (i = this.func_185527_x(state)) < this.func_185526_g() && rand.nextInt(this.getGrowthChance()) == 0) {
            worldIn.func_180501_a(pos, this.func_185528_e(i + 1), 2);
        }
    }

    public abstract int func_185526_g();

    public int getMinLightLevel() {
        return 8;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_185524_e()});
    }

    protected boolean func_185514_i(IBlockState state) {
        return this.isSoil(state);
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return (worldIn.func_175699_k(pos) >= this.getMinLightLevel() || worldIn.func_175678_i(pos)) && this.isSoil(soil);
    }

    public abstract boolean isSoil(IBlockState var1);

    public abstract boolean canPlant(IBlockState var1);

    public boolean func_185525_y(IBlockState state) {
        return this.func_185527_x(state) >= this.func_185526_g();
    }

    public int getGrowthChance() {
        return 20;
    }
}

