/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;

public class PerkMasteryOfScrolls
extends Perk {
    PerkMasteryOfScrolls() {
        super("mastery_of_scrolls", new ResourceLocation("tombstone", "textures/items/scroll.png"));
    }

    @Override
    public int getLevelMax() {
        return 15;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level != actualLevel && (actualLevel != 0 || level != 1) && level != levelWithBonus) {
            return level == actualLevel + 1 ? "+" + level * 10 + "%" : "";
        }
        return "+" + level * 10 + "% " + LangKey.makeClientTranslation("tombstone.perk.mastery_of_scrolls.desc", new Object[0]);
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        int bonus = 0;
        if (Helper.isDateAroundHalloween()) {
            bonus += 5;
        }
        if (Helper.isContributor(player)) {
            bonus += 3;
        }
        return bonus;
    }
}

