/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;

public class PerkGhostlyShape
extends Perk {
    PerkGhostlyShape() {
        super("ghostly_shape", new ResourceLocation("tombstone", "textures/potions/ghostly_shape.png"));
    }

    @Override
    public int getLevelMax() {
        return 5;
    }

    @Override
    public boolean isDisabled() {
        return ConfigTombstone.general.getGhostlyShapeDuration() <= 0;
    }

    @Override
    public String getTranslationKey() {
        return "tombstone.potion.ghostly_shape.name";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTooltip(int level, int actualLevel, int levelWithBonus) {
        if (level == 1) {
            return LangKey.makeClientTranslation("tombstone.potion.feather_fall.name", new Object[0]);
        }
        if (level == 2) {
            return LangKey.MESSAGE_BREATHING.getClientTranslation(new Object[0]);
        }
        if (level == 3) {
            return LangKey.makeClientTranslation("tombstone.potion.purification.name", new Object[0]);
        }
        if (level == 4) {
            return LangKey.makeClientTranslation("tombstone.potion.true_sight.name", new Object[0]);
        }
        return level == 5 ? LangKey.MESSAGE_INVULNERABLE.getClientTranslation(new Object[0]) : "";
    }

    @Override
    public int getCost(int level) {
        return level > 0 ? 1 : 0;
    }

    @Override
    public boolean isEncrypted() {
        return true;
    }

    @Override
    public int getLevelBonus(EntityPlayer player) {
        return Helper.isDateAroundHalloween() ? 5 : 0;
    }
}

