/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFamiliarReceptacle
extends ItemGeneric {
    public ItemFamiliarReceptacle() {
        super("familiar_receptacle", true, false);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.containSoul(stack) || super.func_77636_d(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            ITBCapability cap;
            if (!this.containSoul(stack)) {
                this.addItemDesc(list, "1", new Object[0]);
            } else {
                assert (stack.func_77978_p() != null);
                NBTTagCompound tagPet = (NBTTagCompound)stack.func_77978_p().func_74781_a("dead_pet");
                if (tagPet.func_150297_b("id", 8)) {
                    ResourceLocation id = new ResourceLocation(tagPet.func_74779_i("id"));
                    String key = EntityList.func_191302_a((ResourceLocation)id);
                    this.addItemDesc(list, "2", LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_ITEM, key == null ? LangKey.MESSAGE_UNKNOWN.getKey() : key, new Object[0]));
                    this.addItemUse(list, "" + (this.getDurabilityForDisplay(stack) == 0.0 ? 2 : 1), new Object[0]);
                }
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Integer level = ConfigTombstone.general.getFamiliarReceptacleRequiredLevel();
            ITBCapability iTBCapability = cap = player == null ? null : (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
            if (cap == null || !Helper.isContributor((EntityPlayer)player) && cap.getTotalPerkPoints() < level) {
                this.addWarn(list, LangKey.MESSAGE_KNOWLEDGE_REQUIRED, level);
            }
            this.addInfoInBeta(list);
        } else {
            this.addInfoShowTooltip(list);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && TimeHelper.atInterval(entity.field_70173_aa, TimeHelper.tickFromMinute(1)) && this.containSoul(stack)) {
            float maxHealth;
            NBTTagCompound tag = stack.func_77978_p();
            assert (tag != null);
            NBTTagCompound tagPet = (NBTTagCompound)tag.func_74781_a("dead_pet");
            float health = tagPet.func_150297_b("Health", 5) ? Math.max(0.0f, tagPet.func_74760_g("Health")) : 0.0f;
            float f = maxHealth = tagPet.func_150297_b("max_life", 5) ? Math.max(1.0f, tagPet.func_74760_g("max_life")) : 1.0f;
            if (health < maxHealth) {
                float gain = maxHealth * 0.1f;
                EntityPlayer player = (EntityPlayer)entity;
                tagPet.func_74776_a("Health", Math.min(health + Math.min(player.func_110143_aJ(), gain), maxHealth));
                if (ConfigTombstone.general.allowBeyondTheGraveDamage) {
                    player.func_70097_a(ModDamages.BEYOND_THE_GRAVE, gain);
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.containSoul(stack) && this.getDurabilityForDisplay(stack) > 0.0;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("dead_pet", 10)) {
            NBTTagCompound tagPet = (NBTTagCompound)tag.func_74781_a("dead_pet");
            float health = tagPet.func_150297_b("Health", 5) ? Math.max(0.0f, tagPet.func_74760_g("Health")) : 0.0f;
            float maxHealth = tagPet.func_150297_b("max_life", 5) ? Math.max(1.0f, tagPet.func_74760_g("max_life")) : 1.0f;
            return 1.0f - health / maxHealth;
        }
        return 1.0;
    }

    public boolean containSoul(ItemStack stack) {
        return stack.func_77973_b() == this && stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("dead_pet", 10);
    }

    public boolean revive(EntityPlayer player, BlockPos gravePos, ItemStack stack) {
        if (this.containSoul(stack)) {
            String id;
            Entity entity;
            assert (stack.func_77978_p() != null);
            NBTTagCompound tagPet = (NBTTagCompound)stack.func_77978_p().func_74781_a("dead_pet");
            if (tagPet.func_150297_b("id", 8) && (entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(id = tagPet.func_74779_i("id")), (World)player.field_70170_p)) instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)entity;
                tagPet.func_82580_o("max_life");
                livingEntity.func_70020_e(tagPet);
                livingEntity.func_70606_j(livingEntity.func_110138_aP());
                livingEntity.field_70128_L = false;
                livingEntity.func_70107_b((double)gravePos.func_177958_n() + 0.5, (double)gravePos.func_177956_o() + 0.5, (double)gravePos.func_177952_p() + 0.5);
                livingEntity.field_71093_bK = player.field_71093_bK;
                if (entity instanceof EntityTameable) {
                    EntityTameable pet = (EntityTameable)livingEntity;
                    pet.func_193101_c(player);
                } else if (entity instanceof AbstractHorse) {
                    AbstractHorse horse = (AbstractHorse)livingEntity;
                    horse.func_110263_g(player);
                }
                EntityHelper.clearBadEffects(livingEntity);
                player.field_70170_p.func_72838_d((Entity)livingEntity);
                return true;
            }
        }
        return false;
    }

    public boolean captureSoul(@Nullable EntityLivingBase entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return false;
        }
        boolean isTameable = entity instanceof EntityTameable;
        boolean isHorse = !isTameable && entity instanceof AbstractHorse;
        UUID ownerId = null;
        if (isTameable) {
            ownerId = ((EntityTameable)entity).func_184753_b();
        }
        if (isHorse) {
            ownerId = ((AbstractHorse)entity).func_184780_dh();
        }
        if (ownerId != null && entity.func_184102_h() != null) {
            EntityPlayerMP owner = entity.func_184102_h().func_184103_al().func_177451_a(ownerId);
            if (owner == null && entity.func_184102_h().func_152358_ax().func_152652_a(ownerId) == null) {
                return false;
            }
            String id = EntityList.func_75621_b((Entity)entity);
            if (id != null && !Helper.containRL(ConfigTombstone.decorativeGrave.blackListCapturableSouls, new ResourceLocation(id))) {
                NBTTagCompound tag;
                boolean hasReceptacle;
                IItemHandler inventPlayer = owner == null ? null : (IItemHandler)owner.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                ItemStack receptacle = inventPlayer == null ? ItemStack.field_190927_a : IntStream.range(0, inventPlayer.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventPlayer).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == this && !this.containSoul((ItemStack)stack)).findFirst().orElse(ItemStack.field_190927_a);
                boolean bl = hasReceptacle = !receptacle.func_190926_b();
                if (hasReceptacle && EventFactory.onCaptureSoul((EntityPlayer)owner, entity)) {
                    hasReceptacle = false;
                }
                if (!hasReceptacle && !ConfigTombstone.recovery.recoveryFamiliarEnable) {
                    return false;
                }
                NBTTagCompound pet_tag = entity.serializeNBT();
                pet_tag.func_82580_o("Dimension");
                pet_tag.func_82580_o("Motion");
                pet_tag.func_82580_o("UUID");
                pet_tag.func_82580_o("UpdateBlocked");
                pet_tag.func_74776_a("max_life", entity.func_110138_aP());
                if (!hasReceptacle) {
                    CommandTBReviveFamiliar.saveFamiliar(entity.func_184102_h(), ownerId, pet_tag, entity.func_110124_au().toString());
                    return false;
                }
                IItemHandler inventory = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (inventory != null) {
                    IntStream.range(0, inventory.getSlots()).forEach(slot -> {
                        ItemStack currentStack = inventory.getStackInSlot(slot);
                        if (!currentStack.func_190926_b()) {
                            inventory.extractItem(slot, currentStack.func_190916_E(), false);
                        }
                    });
                }
                if (isHorse && entity instanceof AbstractChestHorse) {
                    ((AbstractChestHorse)entity).func_110207_m(false);
                }
                if ((tag = receptacle.func_77978_p()) == null) {
                    tag = new NBTTagCompound();
                    receptacle.func_77982_d(tag);
                }
                tag.func_74782_a("dead_pet", (NBTBase)pet_tag);
                LangKey.MESSAGE_CAPTURE_FAMILIAR.sendSpecialMessage((ICommandSender)owner, entity.func_70005_c_());
                ModTriggers.CAPTURE_SOUL.trigger(owner);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("dead_pet", 10)) {
            NBTTagCompound tag = stack.func_77978_p().func_74737_b();
            NBTTagCompound pet_tag = (NBTTagCompound)tag.func_74781_a("dead_pet");
            if (pet_tag.func_150297_b("id", 8)) {
                NBTTagCompound newTag = new NBTTagCompound();
                newTag.func_74778_a("id", pet_tag.func_74779_i("id"));
                newTag.func_74776_a("Health", pet_tag.func_74760_g("Health"));
                newTag.func_74776_a("max_life", pet_tag.func_74760_g("max_life"));
                tag.func_74782_a("dead_pet", (NBTBase)newTag);
            } else {
                pet_tag.func_82580_o("dead_pet");
            }
            return tag;
        }
        return stack.func_77978_p();
    }
}

