/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TombstoneDataFixer {
    private static final int DATA_FIXER_VERSION = 2;

    public static void init() {
        ModFixs fixes = FMLCommonHandler.instance().getDataFixer().init("tombstone", 2);
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new TileNamespaceFixer());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new ItemNamespaceFixer());
    }

    private static class ItemNamespaceFixer
    implements IFixableData {
        private final Map<String, ImmutablePair<String, Short>> itemNames;

        private ItemNamespaceFixer() {
            ImmutableMap.Builder nameMap = ImmutableMap.builder();
            nameMap.put((Object)"tombstone:strange_scroll", (Object)ImmutablePair.of((Object)"tombstone:crafting_ingredient", (Object)0)).put((Object)"tombstone:strange_tablet", (Object)ImmutablePair.of((Object)"tombstone:crafting_ingredient", (Object)1)).put((Object)"tombstone:grave_dust", (Object)ImmutablePair.of((Object)"tombstone:crafting_ingredient", (Object)3));
            this.itemNames = nameMap.build();
        }

        public int func_188216_a() {
            return 2;
        }

        public NBTTagCompound func_188217_a(NBTTagCompound compound) {
            String id;
            if (compound.func_150297_b("id", 8) && this.itemNames.containsKey(id = compound.func_74779_i("id"))) {
                ImmutablePair<String, Short> pair = this.itemNames.get(id);
                compound.func_74778_a("id", (String)pair.left);
                compound.func_74777_a("Damage", ((Short)pair.right).shortValue());
            }
            return compound;
        }
    }

    private static class TileNamespaceFixer
    implements IFixableData {
        private final Map<String, String> tileEntityNames;

        private TileNamespaceFixer() {
            ImmutableMap.Builder nameMap = ImmutableMap.builder();
            nameMap.put((Object)"minecraft:writable_grave", (Object)"tombstone:writable_grave").put((Object)"minecraft:tombstone", (Object)"tombstone:tombstone");
            this.tileEntityNames = nameMap.build();
        }

        public int func_188216_a() {
            return 1;
        }

        public NBTTagCompound func_188217_a(NBTTagCompound compound) {
            String id;
            if (compound.func_150297_b("id", 8) && this.tileEntityNames.containsKey(id = compound.func_74779_i("id"))) {
                compound.func_74778_a("id", this.tileEntityNames.get(id));
            }
            return compound;
        }
    }
}

