/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.helper.Helper;

public enum SupportStructures {
    Village("Village", 68, new String[0]),
    Desert_Temple("Temple", 68, new String[]{"minecraft:desert"}),
    Igloo_Temple("Temple", 68, new String[]{"minecraft:ice_flats", "minecraft:taiga_cold"}),
    Jungle_Temple("Temple", 68, new String[]{"minecraft:jungle", "minecraft:mutated_jungle"}),
    Mansion("Mansion", 68, new String[0]),
    Monument("Monument", 68, new String[0]),
    Stronghold("Stronghold", 35, new String[0]),
    EndCity("EndCity", 68, new String[0]),
    Mineshaft("Mineshaft", 37, new String[0]),
    Fortress("Fortress", 35, new String[0]);

    private final String structureName;
    private final int y;
    private final List<String> biomes;

    private SupportStructures(String structureName, int y, String[] biomes) {
        this.structureName = structureName;
        this.y = y;
        this.biomes = biomes.length == 0 ? new ArrayList() : Arrays.asList(biomes);
    }

    public String getStructureName() {
        return this.structureName;
    }

    public int getY() {
        return this.y;
    }

    public boolean isValidBiome(@Nullable ResourceLocation biomeLoc) {
        return biomeLoc != null && (this.biomes.isEmpty() || this.biomes.contains(biomeLoc.toString()));
    }

    @Nullable
    public static SupportStructures getStructure(String name) {
        try {
            return SupportStructures.valueOf(name);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    @Nullable
    public static SupportStructures getRandomStructure(Predicate<SupportStructures> predic) {
        List list = Stream.of(SupportStructures.values()).filter(predic).collect(Collectors.toList());
        return !list.isEmpty() ? (SupportStructures)((Object)list.get(Helper.getRandom(0, list.size() - 1))) : null;
    }
}

