/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.compatibility.CompatibilityAetherLegacy;
import ovh.corail.tombstone.compatibility.CompatibilityBaubles;
import ovh.corail.tombstone.compatibility.CompatibilityGalactiCraft;
import ovh.corail.tombstone.compatibility.CompatibilityRPGInventory;
import ovh.corail.tombstone.compatibility.CompatibilitySmartBackpacks;
import ovh.corail.tombstone.compatibility.CompatibilityTechguns;
import ovh.corail.tombstone.compatibility.CompatibilityTheBetweenLands;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.DeathHandler;

public class InventoryHelper {
    public static boolean autoequip(ItemStack stack, EntityPlayer player) {
        ResourceLocation registryName = stack.func_77973_b().getRegistryName();
        if (!stack.func_190926_b() && registryName != null && !registryName.func_110624_b().equals("powersuits")) {
            if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)stack) > 0) {
                return false;
            }
            if (ConfigTombstone.compatibilities.allowTechgunsAutoEquip && SupportMods.TECHGUNS.isLoaded() && CompatibilityTechguns.instance.autoEquip(stack, player)) {
                return true;
            }
            if (stack.func_77976_d() == 1) {
                boolean canEquip;
                if (ConfigTombstone.compatibilities.allowBaublesAutoEquip && SupportMods.BAUBLES.isLoaded() && CompatibilityBaubles.instance.autoEquip(stack, player)) {
                    return true;
                }
                if (ConfigTombstone.compatibilities.allowGalacticrafAutoEquip && SupportMods.GALACTICRAFT.isLoaded() && CompatibilityGalactiCraft.instance.autoEquip(stack, player)) {
                    return true;
                }
                if (ConfigTombstone.compatibilities.allowRPGInventoryAutoEquip && SupportMods.RPG_INVENTORY.isLoaded() && CompatibilityRPGInventory.instance.autoEquip(stack, player)) {
                    return true;
                }
                if (ConfigTombstone.compatibilities.allowAetherLegacyAutoEquip && SupportMods.AETHER_LEGACY.isLoaded() && CompatibilityAetherLegacy.instance.autoEquip(stack, player)) {
                    return true;
                }
                if (ConfigTombstone.compatibilities.allowTheBetweenLandsAutoEquip && SupportMods.THE_BETWEENLANDS.isLoaded() && CompatibilityTheBetweenLands.instance.autoEquip(stack, player)) {
                    return true;
                }
                if (ConfigTombstone.compatibilities.allowSmartBackpacksAutoEquip && SupportMods.SMART_BACKPACKS.isLoaded() && CompatibilitySmartBackpacks.instance.autoEquip(stack, player)) {
                    return true;
                }
                if (player.func_184592_cb().func_190926_b()) {
                    if (SupportMods.TCONSTRUCT.isLoaded() && registryName.func_110624_b().equals("tconstruct") && registryName.func_110623_a().contains("battlesign") && player.func_174820_d(99, stack.func_77946_l())) {
                        return true;
                    }
                    if (stack.func_77973_b().isShield(stack, (EntityLivingBase)player) && player.func_174820_d(99, stack.func_77946_l())) {
                        return true;
                    }
                }
                EntityEquipmentSlot slot = stack.func_77973_b().getEquipmentSlot(stack);
                boolean isElytra = false;
                if (slot == null) {
                    if (stack.func_77973_b() instanceof ItemArmor) {
                        slot = ((ItemArmor)stack.func_77973_b()).field_77881_a;
                    } else {
                        if (!(stack.func_77973_b() instanceof ItemElytra)) {
                            return false;
                        }
                        slot = EntityEquipmentSlot.CHEST;
                        isElytra = true;
                    }
                } else if (slot == EntityEquipmentSlot.CHEST) {
                    isElytra = InventoryHelper.isElytra(stack);
                }
                int slotId = slot.func_188454_b();
                ItemStack stackInSlot = (ItemStack)player.field_71071_by.field_70460_b.get(slotId);
                if (stackInSlot.func_190926_b()) {
                    player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
                    return true;
                }
                if (slot != EntityEquipmentSlot.CHEST) {
                    return false;
                }
                boolean equipElytraInPriority = DeathHandler.INSTANCE.getOptionEquipElytraInPriority(player.func_110124_au());
                boolean bl = InventoryHelper.isElytra(stackInSlot) ? !isElytra && !equipElytraInPriority : (canEquip = isElytra && equipElytraInPriority);
                if (canEquip) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackInSlot.func_77946_l());
                    player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static ItemStack findItemInMainInventory(EntityPlayer player, Predicate<ItemStack> predic) {
        return player.field_71071_by.field_70462_a.stream().filter(predic).findFirst().orElse(ItemStack.field_190927_a);
    }

    private static boolean isElytra(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemElytra) {
            return true;
        }
        if (!SupportMods.WINGS.isLoaded()) {
            return false;
        }
        ResourceLocation registryName = stack.func_77973_b().getRegistryName();
        assert (registryName != null);
        return registryName.func_110624_b().equals(SupportMods.WINGS.func_176610_l()) && registryName.func_110623_a().endsWith("_wings");
    }

    public static boolean isTool(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77976_d() == 1 && (stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemFishingRod || stack.func_77973_b() instanceof ItemShears);
    }
}

