/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;

public class CommandTBTeleportHome
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbteleporthome";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP target = args.length > 0 ? CommandTBTeleportHome.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[args.length - 1]) : CommandTBTeleportHome.func_71521_c((ICommandSender)sender);
        EntityPlayerMP player = args.length == 2 ? CommandTBTeleportHome.func_71521_c((ICommandSender)sender) : target;
        CommandTBTeleportHome.checkAlive((Entity)player);
        CommandTBTeleportHome.checkNotSpectator((EntityPlayer)player);
        if (player.field_70170_p == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        int dimensionId = target.field_70170_p.field_73011_w.getDimension();
        if (!Helper.isValidDimension(dimensionId)) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_DIMENSION.getKey(), new Object[0]);
        }
        Pair<World, BlockPos> spawnPoint = CommandTBTeleportHome.getRespawnPoint((EntityPlayer)target);
        Location location = new SpawnHelper((WorldServer)spawnPoint.getLeft(), (BlockPos)spawnPoint.getRight()).findSpawnPlace(false);
        CommandTBTeleportHome.checkValidPos((World)spawnPoint.getLeft(), (BlockPos)spawnPoint.getRight());
        EntityPlayerMP newEntity = Helper.teleportEntity(player, location);
        if (EntityHelper.isValidPlayer((EntityPlayer)newEntity)) {
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)newEntity, new Object[0]);
        }
        CommandTBTeleportHome.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_LOG_TELEPORT_SUCCESS.getKey(), (Object[])new Object[]{LangKey.MESSAGE_HERE.getTranslation(new Object[0]), location.x, location.y, location.z, location.dim});
    }

    public static Pair<World, BlockPos> getRespawnPoint(EntityPlayer player) {
        BlockPos pos = player.getBedLocation(player.field_70170_p.field_73011_w.getDimension());
        if (pos != null) {
            return Pair.of((Object)player.field_70170_p, (Object)pos);
        }
        WorldServer spawnWorld = player.func_184102_h().func_71218_a(player.getSpawnDimension());
        pos = player.getBedLocation(player.getSpawnDimension());
        if (pos == null) {
            pos = spawnWorld.func_175694_M();
        }
        return Pair.of((Object)spawnWorld, (Object)pos);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0 || index == 1;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length != 0 && args.length <= 2 ? CommandTBTeleportHome.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
    }
}

