/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBTeleportDeath
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbteleportdeath";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (ConfigTombstone.general.cooldownTeleportDeath < 0) {
            throw LangKey.COMMAND_EXCEPTION_DISABLED.asCommandException(new Object[0]);
        }
        if (args.length > 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        this.teleportDeath(server, sender);
    }

    @Override
    public int func_82362_a() {
        return 0;
    }

    private void teleportDeath(MinecraftServer server, ICommandSender sender) throws CommandException {
        EntityPlayerMP player = CommandTBTeleportDeath.func_71521_c((ICommandSender)sender);
        CommandTBTeleportDeath.checkAlive((Entity)player);
        CommandTBTeleportDeath.checkNotSpectator((EntityPlayer)player);
        Location lastDeathLocation = DeathHandler.INSTANCE.getLastDeathLocation((EntityPlayer)player);
        if (lastDeathLocation.isOrigin()) {
            throw LangKey.COMMAND_EXCEPTION_NO_DEATH_LOCATION.asCommandException(new Object[0]);
        }
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap == null) {
            throw new CommandException(LangKey.COMMAND_EXCEPTION_CAP_NULL.getKey(), new Object[0]);
        }
        int cd = cap.getCooldownToTeleportDeath(player);
        if (cd > 0) {
            int[] timeArray = TimeHelper.getTimeArray(cd);
            player.func_145747_a(LangKey.MESSAGE_COMMAND_IN_COOLDOWN.getTranslation(String.format("%02d", timeArray[0]), String.format("%02d", timeArray[1]), String.format("%02d", timeArray[2])));
        } else {
            if (!Helper.isValidDimension(lastDeathLocation.dim)) {
                throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_DIMENSION.getKey(), new Object[0]);
            }
            WorldServer world = server.func_71218_a(lastDeathLocation.dim);
            Location location = new SpawnHelper(world, lastDeathLocation.getPos()).findSpawnPlace(false);
            if (location.isOrigin()) {
                throw new CommandException(LangKey.COMMAND_EXCEPTION_NO_SPAWN.getKey(), new Object[0]);
            }
            EntityPlayerMP newEntity = Helper.teleportEntity(player, location);
            if (EntityHelper.isValidPlayer((Entity)newEntity)) {
                cap.setCooldownToTeleportDeath(TimeHelper.worldTicks(player.field_70170_p) + (long)TimeHelper.tickFromMinute(ConfigTombstone.general.cooldownTeleportDeath));
                newEntity.func_145747_a(LangKey.MESSAGE_TELEPORT_SUCCESS.getTranslationWithStyle(StyleType.MESSAGE_SPELL, new Object[0]));
            }
            CommandTBTeleportDeath.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_LOG_TELEPORT_SUCCESS.getKey(), (Object[])new Object[]{newEntity.func_70005_c_(), location.x, location.y, location.z, location.dim});
        }
    }
}

