/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public class TBCapabilityDefault
implements ITBCapability {
    protected long knowledge = 0L;
    private final Map<Perk, Integer> perks = new HashMap<Perk, Integer>();
    private long nextPray = -1L;
    private long nextResetPerks = -1L;
    private long nextRequestTeleport = -1L;
    private long nextTeleportDeath = -1L;
    private long nextTeleportBind = -1L;
    protected int alignment = 0;
    protected int alignmentLevel = 0;

    @Override
    public long getKnowledge() {
        return this.knowledge;
    }

    @Override
    public ITBCapability setKnowledge(long points) {
        this.knowledge = Math.max(0L, points);
        return this;
    }

    @Override
    public ITBCapability addKnowledgeAndSync(EntityPlayerMP player, long points) {
        if (!player.field_70170_p.field_72995_K && points > 0L) {
            int newPerkPoints;
            int adjust;
            int oldPerkPoints = this.getTotalPerkPoints();
            this.knowledge += points;
            boolean canDisplay = DeathHandler.INSTANCE.getOptionKnowledgeMessage(player.func_110124_au());
            if (canDisplay) {
                LangKey.MESSAGE_EARN_KNOWLEDGE.sendMagicMessage((ICommandSender)player, LangKey.MESSAGE_YOUR_KNOWLEDGE.getTranslation(new Object[0]), points);
            }
            if ((adjust = (newPerkPoints = this.getTotalPerkPoints()) - oldPerkPoints) > 0) {
                if (canDisplay) {
                    LangKey.MESSAGE_ACCESS_GUI.sendSpecialMessage((ICommandSender)player, adjust, LangKey.MESSAGE_HERE.createComponentCommand("/tbgui", new Object[0]));
                }
                if (oldPerkPoints == 0) {
                    ModTriggers.FIRST_KNOWLEDGE.trigger(player);
                }
                if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                    ModTriggers.MASTERY_1.trigger(player);
                }
            }
            PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
        }
        return this;
    }

    @Override
    public ITBCapability removeKnowledgeAndSync(EntityPlayerMP player, long points) {
        if (!player.field_70170_p.field_72995_K) {
            int oldPerkPoints = this.getTotalPerkPoints();
            this.setKnowledge(this.knowledge - points);
            int lostPerkPoints = oldPerkPoints - this.getTotalPerkPoints();
            if (lostPerkPoints <= 0) {
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
            } else {
                Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk(entry.getKey())) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.nextPray, this.alignment, this.perks), player);
            }
            if (DeathHandler.INSTANCE.getOptionKnowledgeMessage(player.func_110124_au())) {
                LangKey.MESSAGE_LOSE_KNOWLEDGE.sendMagicMessage((ICommandSender)player, LangKey.MESSAGE_YOUR_KNOWLEDGE.getTranslation(new Object[0]), points);
            }
        }
        return this;
    }

    @Override
    public long getKnowledgeForLevel(int level) {
        return level <= 0 ? 0L : (long)(level * level * 2);
    }

    @Override
    public long getKnowledgeToReachNextLevel(int level) {
        return level <= 0 ? 0L : (long)(4 * level - 2);
    }

    @Override
    public int getUsedPerkPoints(EntityPlayer player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey())) {
                it.remove();
                continue;
            }
            Perk perk = entry.getKey();
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += perk.getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)MathHelper.func_76129_c((float)((float)this.knowledge / 2.0f));
    }

    @Override
    public Map<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public ITBCapability setPerks(Map<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ITBCapability setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
        return this;
    }

    @Override
    public boolean removePerk(Perk perk) {
        return this.perks.remove(perk) != null;
    }

    @Override
    public int getPerkLevel(EntityPlayer player, Perk perk) {
        return perk.isDisabled() ? 0 : this.perks.getOrDefault(perk, 0);
    }

    @Override
    public int getPerkLevelWithBonus(EntityPlayer player, @Nullable Perk perk) {
        return EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled() ? Math.min(this.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax()) : 0;
    }

    @Override
    public int getCooldownToPray(EntityPlayer player) {
        int maxPrayTime;
        int cd = (int)(this.nextPray - TimeHelper.worldTicks(player.field_70170_p));
        if (cd > (maxPrayTime = this.getMaxPrayTime(player))) {
            this.resetNextPray(player);
            cd = maxPrayTime;
            if (!player.field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.NEXT_PRAY, this.getNextPray()), (EntityPlayerMP)player);
            }
        }
        return cd;
    }

    @Override
    public ITBCapability resetNextPray(EntityPlayer player) {
        this.nextPray = TimeHelper.worldTicks(player.field_70170_p) + (long)this.getMaxPrayTime(player);
        return this;
    }

    @Override
    public int getMaxPrayTime(EntityPlayer player) {
        int ticks = TimeHelper.tickFromHour(ConfigTombstone.decorativeGrave.getCooldownToPray());
        return Helper.isContributor(player) ? ticks / 2 : ticks;
    }

    @Override
    public long getNextPray() {
        return this.nextPray;
    }

    @Override
    public ITBCapability setNextPray(long worldTime) {
        this.nextPray = worldTime;
        return this;
    }

    @Override
    public boolean canResetPerks(EntityPlayer player) {
        return this.getCooldownToResetPerks(player) <= 0L && this.perks.entrySet().stream().anyMatch(entry -> entry.getKey() != null && (Integer)entry.getValue() > 0 && !((Perk)entry.getKey()).isDisabled());
    }

    @Override
    public long getCooldownToResetPerks(EntityPlayer player) {
        int maxResetTime;
        long worldTicks = TimeHelper.worldTicks(player.field_70170_p);
        long cd = this.nextResetPerks - worldTicks;
        if (cd > (long)(maxResetTime = TimeHelper.tickFromMinute(ConfigTombstone.decorativeGrave.cooldownResetperk))) {
            cd = maxResetTime;
            this.nextResetPerks = worldTicks + (long)maxResetTime;
        }
        return Math.max(cd, 0L);
    }

    @Override
    public boolean resetPerksAndSync(EntityPlayerMP player) {
        if (!player.field_70170_p.field_72995_K && this.canResetPerks((EntityPlayer)player)) {
            this.setPerks(new HashMap<Perk, Integer>());
            this.nextResetPerks = TimeHelper.worldTicks(player.field_70170_p) + (long)TimeHelper.tickFromMinute(ConfigTombstone.decorativeGrave.cooldownResetperk);
            this.syncAll(player);
            return true;
        }
        return false;
    }

    @Override
    public ITBCapability setNextResetPerks(long worldTime) {
        this.nextResetPerks = worldTime;
        return this;
    }

    @Override
    public ITBCapability copyCapability(ITBCapability otherTBCapability) {
        this.deserializeNBT((NBTTagCompound)otherTBCapability.serializeNBT());
        return this;
    }

    @Override
    public ITBCapability syncAll(EntityPlayerMP player) {
        PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.nextPray, this.alignment, this.perks), player);
        return this;
    }

    @Override
    public ITBCapability setCooldownToRequestTeleport(long worldTime) {
        this.nextRequestTeleport = worldTime;
        return this;
    }

    @Override
    public int getCooldownToRequestTeleport(EntityPlayerMP player) {
        int maxResetTime;
        long worldTicks = TimeHelper.worldTicks(player.field_70170_p);
        long cd = this.nextRequestTeleport - worldTicks;
        if (cd > (long)(maxResetTime = TimeHelper.tickFromMinute(ConfigTombstone.general.cooldownRequestTeleport))) {
            this.setCooldownToRequestTeleport(worldTicks + (long)maxResetTime);
            return maxResetTime;
        }
        return Math.max((int)cd, 0);
    }

    @Override
    public ITBCapability setCooldownToTeleportDeath(long worldTime) {
        this.nextTeleportDeath = worldTime;
        return this;
    }

    @Override
    public int getCooldownToTeleportDeath(EntityPlayerMP player) {
        int maxResetTime;
        long worldTicks = TimeHelper.worldTicks(player.field_70170_p);
        long cd = this.nextTeleportDeath - worldTicks;
        if (cd > (long)(maxResetTime = TimeHelper.tickFromMinute(ConfigTombstone.general.cooldownTeleportDeath))) {
            this.setCooldownToTeleportDeath(worldTicks + (long)maxResetTime);
            return maxResetTime;
        }
        return Math.max((int)cd, 0);
    }

    @Override
    public ITBCapability setCooldownToTeleportBind(long worldTime) {
        this.nextTeleportBind = worldTime;
        return this;
    }

    @Override
    public int getCooldownToTeleportBind(EntityPlayerMP player) {
        int maxResetTime;
        long worldTicks = TimeHelper.worldTicks(player.field_70170_p);
        long cd = this.nextTeleportBind - worldTicks;
        if (cd > (long)(maxResetTime = TimeHelper.tickFromMinute(ConfigTombstone.general.cooldownTeleportBind))) {
            this.setCooldownToTeleportBind(worldTicks + (long)maxResetTime);
            return maxResetTime;
        }
        return Math.max((int)cd, 0);
    }

    @Override
    public ITBCapability increaseAlignment(int amount) {
        if (amount > 0 && this.alignmentLevel < 0 || amount < 0 && this.alignmentLevel > 0) {
            amount *= 2;
        }
        return this.setAlignment(this.alignment + amount);
    }

    @Override
    public ITBCapability decreaseAlignment(int amount) {
        return this.increaseAlignment(-amount);
    }

    @Override
    public int getAlignmentValue() {
        return this.alignment;
    }

    @Override
    public int getAlignmentMinValue() {
        return -500;
    }

    @Override
    public int getAlignmentMaxValue() {
        return 500;
    }

    @Override
    public int getAlignmentLevel() {
        if (this.alignment <= -500) {
            return -4;
        }
        if (this.alignment <= -300) {
            return -3;
        }
        if (this.alignment <= -150) {
            return -2;
        }
        if (this.alignment <= -50) {
            return -1;
        }
        if (this.alignment < 50) {
            return 0;
        }
        if (this.alignment < 150) {
            return 1;
        }
        if (this.alignment < 300) {
            return 2;
        }
        return this.alignment < 500 ? 3 : 4;
    }

    @Override
    public ITBCapability setAlignment(int value) {
        this.alignment = MathHelper.func_76125_a((int)value, (int)this.getAlignmentMinValue(), (int)this.getAlignmentMaxValue());
        this.alignmentLevel = this.getAlignmentLevel();
        return this;
    }

    @Override
    public ITBCapability addAlignmentAndSync(EntityPlayerMP player, int amount) {
        if (!player.field_70170_p.field_72995_K) {
            int oldAlignment = this.alignmentLevel;
            this.setAlignment(this.alignment + amount);
            if (oldAlignment != this.alignmentLevel) {
                this.onAlignmentLevelChange(oldAlignment, this.alignmentLevel);
            }
            PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALIGNMENT, this.alignment), player);
        }
        return this;
    }

    @Override
    public ITBCapability onAlignmentLevelChange(int oldAlignment, int newAlignment) {
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("knowledge", this.knowledge);
        nbt.func_74772_a("next_pray", this.nextPray);
        nbt.func_74772_a("next_reset_perks", this.nextResetPerks);
        nbt.func_74772_a("next_request_teleport", this.nextRequestTeleport);
        nbt.func_74772_a("next_teleport_death", this.nextTeleportDeath);
        nbt.func_74772_a("next_teleport_bind", this.nextTeleportBind);
        nbt.func_74768_a("alignment", this.alignment);
        NBTTagList tagPerks = new NBTTagList();
        this.perks.forEach((perk, value) -> {
            if (perk != null && !perk.isDisabled()) {
                NBTTagCompound tagPerk = new NBTTagCompound();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)perk));
                tagPerk.func_74768_a("level", Math.min(perk.getLevelMax(), value));
                tagPerks.func_74742_a((NBTBase)tagPerk);
            }
        });
        nbt.func_74782_a("perks", (NBTBase)tagPerks);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("knowledge", 4)) {
            this.knowledge = nbt.func_74763_f("knowledge");
        }
        if (nbt.func_150297_b("next_pray", 4)) {
            this.nextPray = nbt.func_74763_f("next_pray");
        }
        if (nbt.func_150297_b("next_reset_perks", 4)) {
            this.nextResetPerks = nbt.func_74763_f("next_reset_perks");
        }
        if (nbt.func_150297_b("next_request_teleport", 4)) {
            this.nextResetPerks = nbt.func_74763_f("next_request_teleport");
        }
        if (nbt.func_150297_b("next_teleport_death", 4)) {
            this.nextTeleportDeath = nbt.func_74763_f("next_teleport_death");
        }
        if (nbt.func_150297_b("next_teleport_bind", 4)) {
            this.nextTeleportBind = nbt.func_74763_f("next_teleport_bind");
        }
        if (nbt.func_150297_b("alignment", 3)) {
            this.setAlignment(nbt.func_74762_e("alignment"));
        }
        if (nbt.func_150297_b("perks", 9)) {
            NBTTagList tagPerks = nbt.func_150295_c("perks", 10);
            IntStream.range(0, tagPerks.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)tagPerks).func_150305_b(arg_0)).filter(tagPerk -> tagPerk.func_150297_b("id", 3) && tagPerk.func_150297_b("level", 3)).forEach(tagPerk -> {
                Perk perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"));
                if (perk != null && !perk.isDisabled()) {
                    this.perks.put(perk, Math.min(perk.getLevelMax(), tagPerk.func_74762_e("level")));
                }
            });
        }
    }
}

