/*
 * Decompiled with CFR 0.152.
 */
package death_compass.capabilities.base;

import death_compass.DeathCompass;
import death_compass.capabilities.base.EntityCapability;
import death_compass.network.client.MessageSyncEntityCapabilities;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityCapabilityTracker {
    private final EntityCapability<?, ?, ?> entityCapability;
    private final EntityPlayerMP watcher;
    private boolean trackerReady = true;
    private int lastUpdate = 0;

    public EntityCapabilityTracker(EntityCapability<?, ?, ?> entityCapability, EntityPlayerMP watcher) {
        this.entityCapability = entityCapability;
        this.watcher = watcher;
    }

    public EntityPlayerMP getWatcher() {
        return this.watcher;
    }

    public EntityCapability<?, ?, ?> getEntityCapability() {
        return this.entityCapability;
    }

    public void update() {
        if (this.lastUpdate < this.entityCapability.getTrackingTime()) {
            ++this.lastUpdate;
        } else {
            this.trackerReady = true;
        }
        if (this.trackerReady && this.entityCapability.isDirty()) {
            this.lastUpdate = 0;
            this.trackerReady = false;
            this.entityCapability.setDirty(false);
            this.sendPacket();
        }
    }

    public void sendPacket() {
        MessageSyncEntityCapabilities message = new MessageSyncEntityCapabilities(this.entityCapability);
        DeathCompass.NETWORK_WRAPPER.sendTo((IMessage)message, this.watcher);
    }
}

