/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.start;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomes;
import twilightforest.structures.StructureTFComponentTemplate;
import twilightforest.structures.darktower.ComponentTFDarkTowerMain;
import twilightforest.structures.lichtower.ComponentTFTowerMain;
import twilightforest.world.TFBiomeProvider;
import twilightforest.world.TFWorld;

public abstract class StructureStartTFAbstract
extends StructureStart {
    private static int NUM_LOCKS = 4;
    public boolean isConquered;
    public byte[] lockBytes = new byte[NUM_LOCKS];
    @Deprecated
    private TFFeature feature;

    public StructureStartTFAbstract() {
    }

    public StructureStartTFAbstract(World world, TFFeature feature, Random rand, int chunkX, int chunkZ) {
        this.feature = feature;
        int x = (chunkX << 4) + 8;
        int z = (chunkZ << 4) + 8;
        int y = TFWorld.SEALEVEL + 1;
        this.isConquered = false;
        StructureComponent firstComponent = this.makeFirstComponent(world, feature, rand, x, y, z);
        if (firstComponent != null) {
            this.field_75075_a.add(firstComponent);
            firstComponent.func_74861_a(firstComponent, this.field_75075_a, rand);
        }
        this.func_75072_c();
        if (firstComponent instanceof ComponentTFTowerMain || firstComponent instanceof ComponentTFDarkTowerMain) {
            this.moveToAvgGroundLevel(world, x, z);
        }
        this.setupComponents(world);
    }

    protected abstract StructureComponent makeFirstComponent(World var1, TFFeature var2, Random var3, int var4, int var5, int var6);

    protected void moveToAvgGroundLevel(World world, int x, int z) {
        if (world.func_72959_q() instanceof TFBiomeProvider) {
            Biome biomeAt = world.func_180494_b(new BlockPos(x, 0, z));
            int offY = (int)((biomeAt.func_185355_j() + biomeAt.func_185360_m()) * 8.0f);
            if (biomeAt == TFBiomes.darkForest) {
                offY += 4;
            }
            if (offY > 0) {
                this.field_75074_b.func_78886_a(0, offY, 0);
                for (StructureComponent com : this.func_186161_c()) {
                    com.func_74874_b().func_78886_a(0, offY, 0);
                }
            }
        }
    }

    public void func_143022_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143022_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("Conquered", this.isConquered);
        par1NBTTagCompound.func_74773_a("Locks", this.lockBytes);
        par1NBTTagCompound.func_74768_a("FeatureID", this.feature.ordinal());
    }

    public void func_143017_b(NBTTagCompound nbttagcompound) {
        super.func_143017_b(nbttagcompound);
        this.isConquered = nbttagcompound.func_74767_n("Conquered");
        this.lockBytes = nbttagcompound.func_74770_j("Locks");
        this.feature = TFFeature.values()[nbttagcompound.func_74762_e("FeatureID")];
    }

    protected void setupComponents(World world) {
        TemplateManager templateManager = world.func_72860_G().func_186340_h();
        MinecraftServer server = world.func_73046_m();
        for (StructureComponent component : this.field_75075_a) {
            if (!(component instanceof StructureTFComponentTemplate)) continue;
            ((StructureTFComponentTemplate)component).setup(templateManager, server);
        }
    }

    public boolean isLocked(int lockIndex) {
        if (lockIndex < this.lockBytes.length) {
            TwilightForestMod.LOGGER.info("Checking locks for lockIndex " + lockIndex);
            for (int i = 0; i < this.lockBytes.length; ++i) {
                TwilightForestMod.LOGGER.info("Lock " + i + " = " + this.lockBytes[i]);
            }
            return this.lockBytes[lockIndex] != 0;
        }
        TwilightForestMod.LOGGER.warn("Current lock index, " + lockIndex + " is beyond array bounds " + this.lockBytes.length);
        return false;
    }

    public boolean func_75069_d() {
        return this.feature.isStructureEnabled;
    }
}

