/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;
import twilightforest.util.TFItemStackUtils;

@Mod.EventBusSubscriber(modid="twilightforest")
public class ItemTFFieryPick
extends ItemPickaxe
implements ModelRegisterCallback {
    protected ItemTFFieryPick(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.func_77637_a(TFItems.creativeTab);
    }

    @SubscribeEvent
    public static void onDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() != null && !event.getHarvester().func_184614_ca().func_190926_b() && event.getHarvester().field_71071_by.func_70448_g().func_77973_b() == TFItems.fiery_pickaxe && ForgeHooks.canHarvestBlock((Block)event.getState().func_177230_c(), (EntityPlayer)event.getHarvester(), (IBlockAccess)event.getWorld(), (BlockPos)event.getPos())) {
            ArrayList<ItemStack> removeThese = new ArrayList<ItemStack>();
            ArrayList<ItemStack> addThese = new ArrayList<ItemStack>();
            for (ItemStack input : event.getDrops()) {
                ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(input);
                if (result.func_190926_b()) continue;
                int combinedCount = input.func_190916_E() * result.func_190916_E();
                addThese.addAll((Collection<ItemStack>)TFItemStackUtils.splitToSize(new ItemStack(result.func_77973_b(), combinedCount, result.func_77952_i())));
                removeThese.add(input);
                int i = combinedCount;
                float f = FurnaceRecipes.func_77602_a().func_151398_b(result);
                if (f == 0.0f) {
                    i = 0;
                } else if (f < 1.0f) {
                    int j = MathHelper.func_76141_d((float)((float)i * f));
                    if (j < MathHelper.func_76123_f((float)((float)i * f)) && Math.random() < (double)((float)i * f - (float)j)) {
                        ++j;
                    }
                    i = j;
                }
                while (i > 0) {
                    int k = EntityXPOrb.func_70527_a((int)i);
                    i -= k;
                    event.getHarvester().field_70170_p.func_72838_d((Entity)new EntityXPOrb(event.getWorld(), event.getHarvester().field_70165_t, event.getHarvester().field_70163_u + 0.5, event.getHarvester().field_70161_v, k));
                }
                ItemTFFieryPick.spawnParticles((WorldServer)event.getWorld(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p());
            }
            event.getDrops().removeAll(removeThese);
            event.getDrops().addAll(addThese);
        }
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, @Nullable EntityLivingBase attacker) {
        boolean result = super.func_77644_a(stack, target, attacker);
        if (result && !target.func_70045_F()) {
            ItemTFFieryPick.spawnParticles((WorldServer)target.field_70170_p, target.field_70165_t, target.field_70163_u, target.field_70161_v);
            target.func_70015_d(15);
        }
        return result;
    }

    private static void spawnParticles(WorldServer world, double x, double y, double z) {
        for (int i = 0; i < 5; ++i) {
            double rx = field_77697_d.nextGaussian() * 0.02;
            double ry = field_77697_d.nextGaussian() * 0.02;
            double rz = field_77697_d.nextGaussian() * 0.02;
            double magnitude = 20.0;
            world.func_175739_a(EnumParticleTypes.FLAME, x + 0.5 + rx * 20.0, y + 0.5 + ry * 20.0, z + 0.5 + rz * 20.0, 5, 0.0, 0.0, 0.0, 0.02, new int[0]);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]));
    }
}

