/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.shader;

import java.util.function.IntSupplier;
import net.minecraft.client.renderer.OpenGlHelper;
import twilightforest.client.shader.FloatSupplier;
import twilightforest.client.shader.ShaderManager;

public abstract class ShaderUniform {
    protected final String name;

    protected ShaderUniform(String name) {
        this.name = name;
    }

    public abstract void assignUniform(int var1);

    public static ShaderUniform create(String name, final int value) {
        return new ShaderUniform(name){

            @Override
            public void assignUniform(int shader) {
                OpenGlHelper.func_153163_f((int)OpenGlHelper.func_153194_a((int)shader, (CharSequence)this.name), (int)value);
            }
        };
    }

    public static ShaderUniform create(String name, final IntSupplier supplier) {
        return new ShaderUniform(name){

            @Override
            public void assignUniform(int shader) {
                OpenGlHelper.func_153163_f((int)OpenGlHelper.func_153194_a((int)shader, (CharSequence)this.name), (int)supplier.getAsInt());
            }
        };
    }

    public static ShaderUniform create(String name, final int value0, final int value1) {
        return new ShaderUniform(name){

            @Override
            public void assignUniform(int shader) {
                ShaderManager.glUniform2i(OpenGlHelper.func_153194_a((int)shader, (CharSequence)this.name), value0, value1);
            }
        };
    }

    public static ShaderUniform create(String name, final IntSupplier supplier0, final IntSupplier supplier1) {
        return new ShaderUniform(name){

            @Override
            public void assignUniform(int shader) {
                ShaderManager.glUniform2i(OpenGlHelper.func_153194_a((int)shader, (CharSequence)this.name), supplier0.getAsInt(), supplier1.getAsInt());
            }
        };
    }

    public static ShaderUniform create(String name, final float value) {
        return new ShaderUniform(name){

            @Override
            public void assignUniform(int shader) {
                ShaderManager.glUniform1f(OpenGlHelper.func_153194_a((int)shader, (CharSequence)this.name), value);
            }
        };
    }

    public static ShaderUniform create(String name, final FloatSupplier supplier) {
        return new ShaderUniform(name){

            @Override
            public void assignUniform(int shader) {
                ShaderManager.glUniform1f(OpenGlHelper.func_153194_a((int)shader, (CharSequence)this.name), supplier.get());
            }
        };
    }

    public static ShaderUniform create(String name, final float value0, final float value1) {
        return new ShaderUniform(name){

            @Override
            public void assignUniform(int shader) {
                ShaderManager.glUniform2f(OpenGlHelper.func_153194_a((int)shader, (CharSequence)this.name), value0, value1);
            }
        };
    }

    public static ShaderUniform create(String name, final FloatSupplier supplier0, final FloatSupplier supplier1) {
        return new ShaderUniform(name){

            @Override
            public void assignUniform(int shader) {
                ShaderManager.glUniform2f(OpenGlHelper.func_153194_a((int)shader, (CharSequence)this.name), supplier0.get(), supplier1.get());
            }
        };
    }
}

