/*
 * Decompiled with CFR 0.152.
 */
package com.karjah.betterbedrock.event;

import com.karjah.betterbedrock.event.WorldTick;
import com.karjah.betterbedrock.util.LogHelper;
import com.karjah.betterbedrock.worldGen.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;

public enum Events {
    WORLDTICK(WorldTick.class),
    WORLD_GENERATOR(WorldGenerator.class);

    private final Class eventClass;

    private Events(Class eventClass) {
        this.eventClass = eventClass;
    }

    public Class getEventClass() {
        return this.eventClass;
    }

    public static void registerEvents() {
        for (Events e : Events.values()) {
            try {
                MinecraftForge.EVENT_BUS.register(e.getEventClass().newInstance());
                LogHelper.internal(String.format("Registered event: %s", e.getEventClass().getCanonicalName()));
            }
            catch (Exception ex) {
                LogHelper.error(String.format("Error registering event: %s", e.getEventClass().getCanonicalName()));
                ex.printStackTrace();
            }
        }
    }
}

