/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.util;

import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.capability.AbstractInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;

public class ItemInventoryHandler
extends AbstractInventory
implements ItemGuiData.IInventoryItem,
ICapabilityProvider {
    public final ItemStack inv;
    public final ItemStack[] cache;
    public final int stacksize;

    public ItemInventoryHandler(ItemStack inv, int slots, int stacksize) {
        this.inv = inv;
        this.cache = new ItemStack[slots];
        this.stacksize = stacksize;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.cache[slot] = stack;
        String k = Integer.toHexString(slot);
        if (stack.func_190926_b()) {
            this.inv.func_190919_e(k);
        } else {
            this.inv.func_77983_a(k, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
    }

    public int getSlots() {
        return this.cache.length;
    }

    public ItemStack getStackInSlot(int slot) {
        ItemStack stack = this.cache[slot];
        if (stack != null) {
            return stack;
        }
        NBTTagCompound nbt = this.inv.func_179543_a(Integer.toHexString(slot));
        this.cache[slot] = nbt == null ? ItemStack.field_190927_a : new ItemStack(nbt);
        return this.cache[slot];
    }

    public int getSlotLimit(int slot) {
        return this.stacksize;
    }

    public int insertAm(int slot, ItemStack item) {
        return this.stacksize;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        return (T)((Object)(cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null));
    }

    public void update() {
        for (int i = 0; i < this.cache.length; ++i) {
            NBTTagCompound nbt = this.inv.func_179543_a(Integer.toHexString(i));
            this.cache[i] = nbt == null ? ItemStack.field_190927_a : new ItemStack(nbt);
        }
    }
}

