/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DropedItemInterface
extends BaseTileEntity
implements DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver,
IItemHandler {
    public static int INTERVAL = 20;
    public static int MAX_RANGE = 15;
    public static int INV_SIZE = 5;
    private List<EntityItem> entities = new ArrayList<EntityItem>(1);
    private AxisAlignedBB area;
    private int count;
    public final int[] settings = new int[]{1, 1, 0, 0, 0, 0};
    private long lastCheck;

    private void check() {
        if (this.area == null) {
            this.area = this.getOrientation().rotate(new AxisAlignedBB((double)(-this.settings[2]), (double)(-this.settings[4]), (double)(-this.settings[1]), (double)(this.settings[3] + 1), (double)(this.settings[5] + 1), 0.0)).func_186670_a(this.field_174879_c);
        }
        this.entities = this.field_145850_b.func_72872_a(EntityItem.class, this.area);
        this.entities.add(null);
        this.count = this.entities.size();
    }

    public int getSlots() {
        return this.count;
    }

    public ItemStack getStackInSlot(int slot) {
        EntityItem e = this.entities.get(slot);
        if (e != null) {
            if (e.field_70128_L) {
                this.entities.set(slot, null);
            } else {
                return e.func_92059_d();
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int n = stack.func_190916_E();
        if (n <= 0) {
            return ItemStack.field_190927_a;
        }
        EntityItem e = this.entities.get(slot);
        if (e == null || e.field_70128_L) {
            n -= stack.func_77976_d();
            if (!simulate) {
                stack = stack.func_77946_l();
                if (n > 0) {
                    stack.func_190917_f(-n);
                }
                BlockPos pos = this.field_174879_c.func_177967_a(this.getOrientation().front, this.settings[0]);
                e = new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                e.field_70159_w = 0.0;
                e.field_70181_x = 0.0;
                e.field_70179_y = 0.0;
                this.field_145850_b.func_72838_d((Entity)e);
                this.entities.set(slot, e);
                if (++slot == this.count && this.count < INV_SIZE) {
                    this.entities.add(slot, null);
                    ++this.count;
                }
            }
            return n > 0 ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)n) : ItemStack.field_190927_a;
        }
        ItemStack item = e.func_92059_d();
        int m = item.func_77976_d() - item.func_190916_E();
        if (m < 0 || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)item)) {
            return stack;
        }
        if (!simulate) {
            item.func_190917_f(n < m ? n : m);
            e.func_92058_a(item);
        }
        return (n -= m) > 0 ? ItemHandlerHelper.copyStackWithSize((ItemStack)item, (int)n) : ItemStack.field_190927_a;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack;
        int n;
        EntityItem e = this.entities.get(slot);
        if (e == null) {
            return ItemStack.field_190927_a;
        }
        if (!e.field_70128_L && (n = (stack = e.func_92059_d()).func_190916_E()) > 0) {
            if (n < amount) {
                amount = n;
            }
            ItemStack item = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
            if (!simulate) {
                stack.func_190920_e(n -= amount);
                e.func_92058_a(stack);
                if (n <= 0) {
                    this.entities.set(slot, null);
                }
            }
            return item;
        }
        this.entities.set(slot, null);
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            long t = this.field_145850_b.func_82737_E();
            if (t - this.lastCheck > (long)INTERVAL) {
                this.lastCheck = t;
                this.check();
            }
            return (T)((Object)this);
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] arr = nbt.func_74759_k("settings");
        System.arraycopy(arr, 0, this.settings, 0, Math.min(arr.length, this.settings.length));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74783_a("settings", this.settings);
        return super.func_189515_b(nbt);
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        byte cmd = data.readByte();
        if (cmd < 0 || cmd >= 6) {
            return;
        }
        int v = data.readByte() & 0xFF;
        if (v > MAX_RANGE) {
            v = MAX_RANGE;
        }
        if (cmd == 0 && v > this.settings[1]) {
            v = this.settings[1];
        }
        this.settings[cmd] = v;
        if (cmd == 1 && this.settings[0] > v) {
            this.settings[0] = v;
        }
        if (cmd > 0) {
            this.area = null;
        }
        this.func_70296_d();
    }

    public void initContainer(DataContainer container) {
    }

    public int[] getSyncVariables() {
        return this.settings;
    }

    public void setSyncVariable(int i, int v) {
        this.settings[i] = v;
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }
}

