/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.indlog.util.VariableInventory;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.GlitchSaveSlot;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.tileentity.BaseTileEntity;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Buffer
extends BaseTileEntity
implements AdvancedBlock.ITilePlaceHarvest,
DataContainer.IGuiData,
BlockGuiHandler.ClientPacketReceiver,
AdvancedBlock.IComparatorSource {
    public static final int[] SLOTS = new int[]{12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final int[] STACKS = new int[]{64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public final VariableInventory inventory;
    public final VariableInventory.GroupAccess[] sideAccs = new VariableInventory.GroupAccess[6];
    public byte type;
    private int comparator;
    public byte selSide = (byte)-1;

    public Buffer() {
        this.inventory = new VariableInventory(0, this::func_70296_d);
    }

    public Buffer(IBlockState state) {
        super(state);
        this.type = (byte)this.field_145854_h.func_176201_c(state);
        this.inventory = new VariableInventory(SLOTS[this.type], this::func_70296_d);
        this.inventory.stackSize = STACKS[this.type];
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)this.inventory;
            }
            VariableInventory.GroupAccess acc = this.sideAccs[facing.ordinal()];
            return (T)(acc != null ? acc : this.inventory);
        }
        return null;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74774_a("type", this.type);
        nbt.func_74757_a("lock", this.inventory.locked);
        this.save(nbt);
        for (int i = 0; i < this.sideAccs.length; ++i) {
            VariableInventory.GroupAccess acc = this.sideAccs[i];
            if (acc == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("s", (byte)acc.start);
            tag.func_74774_a("e", (byte)(acc.start + acc.size));
            nbt.func_74782_a("sacc" + i, (NBTBase)tag);
        }
        return super.func_189515_b(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = nbt.func_74771_c("type");
        this.inventory.items = new ItemStack[SLOTS[this.type]];
        this.inventory.locked = nbt.func_74767_n("lock");
        this.load(nbt);
        for (int i = 0; i < this.sideAccs.length; ++i) {
            String k = "sacc" + i;
            if (nbt.func_150297_b(k, 10)) {
                NBTTagCompound tag = nbt.func_74775_l(k);
                VariableInventory.GroupAccess acc = new VariableInventory.GroupAccess(this.inventory);
                acc.setRange(tag.func_74771_c("s") & 0xFF, tag.func_74771_c("e") & 0xFF);
                this.sideAccs[i] = acc;
                continue;
            }
            this.sideAccs[i] = null;
        }
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (item.func_77942_o()) {
            this.load(item.func_77978_p());
        }
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.save(nbt);
        return this.makeDefaultDrops(nbt);
    }

    private void load(NBTTagCompound nbt) {
        this.inventory.slots = nbt.func_74771_c("slots") & 0xFF;
        this.inventory.stackSize = nbt.func_74762_e("stack");
        if (this.inventory.stackSize < 1) {
            this.inventory.stackSize = 1;
        }
        Arrays.fill(this.inventory.items, ItemStack.field_190927_a);
        for (NBTBase t : nbt.func_150295_c("Items", 10)) {
            NBTTagCompound tag = (NBTTagCompound)t;
            int s = tag.func_74771_c("Slot") & 0xFF;
            if (s >= this.inventory.items.length) continue;
            ItemStack stack = new ItemStack(tag);
            stack.func_190920_e(tag.func_74762_e("Num"));
            this.inventory.items[s] = stack;
        }
        this.comparator = this.inventory.getComparatorValue();
    }

    private void save(NBTTagCompound nbt) {
        nbt.func_74774_a("slots", (byte)this.inventory.slots);
        nbt.func_74768_a("stack", this.inventory.stackSize);
        NBTTagList list = new NBTTagList();
        for (int s = 0; s < this.inventory.items.length; ++s) {
            ItemStack stack = this.inventory.items[s];
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)s);
            stack.func_77955_b(tag);
            tag.func_82580_o("Count");
            tag.func_74768_a("Num", stack.func_190916_E());
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int getStart() {
        if (this.selSide < 0 || this.selSide >= this.sideAccs.length) {
            return 0;
        }
        VariableInventory.GroupAccess acc = this.sideAccs[this.selSide];
        return acc == null ? 0 : acc.start;
    }

    public int getEnd() {
        if (this.selSide < 0 || this.selSide >= this.sideAccs.length) {
            return this.inventory.slots;
        }
        VariableInventory.GroupAccess acc = this.sideAccs[this.selSide];
        return acc == null ? this.inventory.slots : acc.start + acc.size;
    }

    public void initContainer(DataContainer container) {
        TileContainer cont = (TileContainer)container;
        int n = this.inventory.items.length;
        for (int i = 0; i < n; ++i) {
            cont.addItemSlot((Slot)new GlitchSaveSlot((IItemHandler)this.inventory, i, 8 + i % 12 * 18, 16 + i / 12 * 18));
        }
        cont.addPlayerInventory(8, 32 + (n + 11) / 12 * 18);
    }

    public int[] getSyncVariables() {
        int[] data = new int[8];
        data[0] = this.inventory.slots | (this.inventory.locked ? 65536 : 0);
        data[1] = this.inventory.stackSize;
        for (int i = 0; i < this.sideAccs.length; ++i) {
            VariableInventory.GroupAccess acc = this.sideAccs[i];
            data[i + 2] = acc == null ? 0 : acc.start & 0xFF | acc.size << 8 & 0xFF00 | 0x10000;
        }
        return data;
    }

    public void setSyncVariable(int i, int v) {
        switch (i) {
            case 0: {
                this.inventory.slots = v & 0xFFFF;
                this.inventory.locked = (v & 0x10000) != 0;
                break;
            }
            case 1: {
                this.inventory.stackSize = v;
                break;
            }
            default: {
                if ((i -= 2) >= this.sideAccs.length) {
                    return;
                }
                if (v == 0) {
                    this.sideAccs[i] = null;
                    break;
                }
                VariableInventory.GroupAccess acc = this.sideAccs[i];
                if (acc == null) {
                    this.sideAccs[i] = acc = new VariableInventory.GroupAccess(this.inventory);
                }
                acc.setRange(v & 0xFF, (v & 0xFF) + (v >> 8 & 0xFF));
            }
        }
    }

    public boolean detectAndSendChanges(DataContainer container, PacketBuffer dos) {
        return false;
    }

    public void updateClientChanges(DataContainer container, PacketBuffer dis) {
    }

    public void onPacketFromClient(PacketBuffer data, EntityPlayer sender) throws IOException {
        switch (data.readByte()) {
            case 0: {
                this.inventory.slots = data.readByte() & 0xFF;
                if (this.inventory.slots <= SLOTS[this.type]) break;
                this.inventory.slots = SLOTS[this.type];
                break;
            }
            case 1: {
                this.inventory.stackSize = data.readInt();
                if (this.inventory.stackSize > STACKS[this.type]) {
                    this.inventory.stackSize = STACKS[this.type];
                    break;
                }
                if (this.inventory.stackSize >= 1) break;
                this.inventory.stackSize = 1;
                break;
            }
            case 2: {
                byte s = data.readByte();
                if (s < 0 || s >= this.sideAccs.length) {
                    return;
                }
                this.sideAccs[s] = null;
                break;
            }
            case 3: {
                byte s = data.readByte();
                if (s < 0 || s >= this.sideAccs.length) {
                    return;
                }
                VariableInventory.GroupAccess acc = this.sideAccs[s];
                if (acc == null) {
                    this.sideAccs[s] = acc = new VariableInventory.GroupAccess(this.inventory);
                }
                acc.setRange(data.readByte() & 0xFF, data.readByte() & 0xFF);
                break;
            }
            case 4: {
                this.inventory.locked ^= true;
            }
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        if (!this.field_145850_b.field_72995_K && this.comparator >= 0) {
            this.comparator = -1;
            TickRegistry.instance.updates.add(() -> this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h));
        }
        super.func_70296_d();
    }

    public int comparatorValue() {
        return this.comparator < 0 ? (this.comparator = this.inventory.getComparatorValue()) : this.comparator;
    }
}

