/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.multiblock;

import cd4017be.api.IAbstractTile;
import cd4017be.indlog.Objects;
import cd4017be.indlog.multiblock.ConComp;
import cd4017be.indlog.multiblock.IActiveCon;
import cd4017be.indlog.multiblock.WarpPipeNetwork;
import cd4017be.indlog.tileentity.WarpPipe;
import cd4017be.lib.templates.NetworkNode;
import cd4017be.lib.util.Utils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class WarpPipeNode
extends NetworkNode<WarpPipeNode, WarpPipeNetwork, WarpPipe> {
    public final byte[] con = new byte[6];
    public byte hasFilters = 0;
    public byte isBlocked = 0;
    public boolean redstone = false;
    public ConComp[] cons = new ConComp[6];

    public WarpPipeNode(WarpPipe pipe) {
        super((IAbstractTile)pipe);
    }

    public void setUID(long uid) {
        super.setUID(uid);
        if (this.network == null) {
            new WarpPipeNetwork(this);
        }
        if (!((WarpPipe)this.tile).isClient()) {
            for (ConComp con : this.cons) {
                if (!(con instanceof IActiveCon)) continue;
                ((IActiveCon)((Object)con)).enable();
            }
        }
    }

    public void onRemoved() {
        for (ConComp c : this.cons) {
            if (c == null) continue;
            ((WarpPipeNetwork)this.network).remConnector(c);
            if (!(c instanceof IActiveCon)) continue;
            ((IActiveCon)((Object)c)).disable();
        }
    }

    public void updateCons() {
        super.updateCons();
        for (ConComp con : this.cons) {
            if (!(con instanceof WarpPipeNetwork.IObjLink)) continue;
            ((WarpPipeNetwork.IObjLink)((Object)con)).updateLink();
        }
    }

    public void addConnector(ConComp con) {
        this.cons[con.side] = con;
        ((WarpPipeNetwork)this.network).addConnector(con);
        if (con instanceof WarpPipeNetwork.IObjLink) {
            this.markDirty();
        }
        if (!((WarpPipe)this.tile).invalid()) {
            Utils.notifyNeighborTile((TileEntity)((TileEntity)this.tile), (EnumFacing)EnumFacing.field_82609_l[con.side]);
            if (!((WarpPipe)this.tile).isClient() && con instanceof IActiveCon) {
                ((IActiveCon)((Object)con)).enable();
            }
        }
    }

    public ConComp remConnector(byte side) {
        this.con[side] = 0;
        ConComp con = this.cons[side];
        ((WarpPipeNetwork)this.network).remConnector(con);
        this.cons[side] = null;
        this.markDirty();
        this.hasFilters = (byte)(this.hasFilters & ~(1 << side));
        ((WarpPipe)this.tile).markUpdate();
        if (!((WarpPipe)this.tile).invalid()) {
            Utils.notifyNeighborTile((TileEntity)((TileEntity)this.tile), (EnumFacing)EnumFacing.field_82609_l[con.side]);
        }
        if (con instanceof IActiveCon) {
            ((IActiveCon)((Object)con)).disable();
        }
        return con;
    }

    public boolean canConnect(byte side) {
        return this.con[side] == 0;
    }

    public void setConnect(byte side, boolean c) {
        byte c0 = this.con[side];
        if (!c && c0 == 0) {
            this.con[side] = 1;
            ((WarpPipeNetwork)this.network).onDisconnect(this, side);
        } else if (c && c0 == 1) {
            this.con[side] = 0;
            this.markDirty();
        }
    }

    public static WarpPipeNode readFromNBT(WarpPipe tile, NBTTagCompound nbt) {
        WarpPipeNode pipe = new WarpPipeNode(tile);
        NBTTagList list = nbt.func_150295_c("connectors", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ConComp con = ConComp.readFromNBT(pipe, list.func_150305_b(i));
            if (con == null) continue;
            pipe.cons[con.side] = con;
        }
        pipe.isBlocked = nbt.func_74771_c("block");
        pipe.redstone = nbt.func_74767_n("rs");
        new WarpPipeNetwork(pipe);
        return pipe;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (byte i = 0; i < this.con.length; i = (byte)((byte)(i + 1))) {
            if (this.con[i] <= 0) continue;
            NBTTagCompound tag = ConComp.writeToNBT(this.con[i], i);
            ConComp comp = this.cons[i];
            if (comp != null) {
                comp.save(tag);
            }
            list.func_74742_a((NBTBase)tag);
        }
        if (!list.func_82582_d()) {
            nbt.func_74782_a("connectors", (NBTBase)list);
        }
        nbt.func_74774_a("block", this.isBlocked);
        nbt.func_74757_a("rs", this.redstone);
    }

    public Capability<WarpPipeNode> getCap() {
        return Objects.WARP_PIPE_CAP;
    }
}

