/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.multiblock;

import cd4017be.indlog.Objects;
import cd4017be.indlog.multiblock.FluidComp;
import cd4017be.indlog.multiblock.IActiveCon;
import cd4017be.indlog.multiblock.WarpPipeNetwork;
import cd4017be.indlog.multiblock.WarpPipeNode;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.util.ItemFluidUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidInjector
extends FluidComp
implements IActiveCon {
    public static int INTERVAL = 4;
    private int timer = Integer.MIN_VALUE;
    private int slotIdx = 0;

    public FluidInjector(WarpPipeNode pipe, byte side) {
        super(pipe, side);
    }

    @Override
    public void enable() {
        if (this.timer < 0 && !this.pipe.invalid()) {
            this.timer = 0;
            TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
        }
    }

    @Override
    public void disable() {
        this.timer = Integer.MIN_VALUE;
    }

    public boolean tick() {
        if (++this.timer < INTERVAL) {
            return this.timer > 0;
        }
        if (this.pipe.invalid()) {
            this.disable();
            return false;
        }
        this.timer = 0;
        if (!this.isValid() || this.filter != null && !this.filter.active(this.pipe.redstone) || (this.pipe.isBlocked & 1 << this.side) != 0) {
            return true;
        }
        IFluidHandler acc = (IFluidHandler)this.link.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
        if (acc == null) {
            return true;
        }
        byte pr = this.filter == null || !this.filter.blocking() ? (byte)-128 : (byte)this.filter.priority();
        IFluidTankProperties[] tprs = ItemFluidUtil.listTanks((IFluidHandler)acc);
        int m = tprs.length;
        for (int i = this.slotIdx; i < this.slotIdx + m; ++i) {
            IFluidTankProperties prop = tprs[i % m];
            if (!prop.canFill()) continue;
            FluidStack stack = prop.getContents();
            int n = prop.getCapacity();
            if (n <= 0) continue;
            if (stack == null) {
                stack = ((WarpPipeNetwork)this.pipe.network).extractFluid(fluid -> this.acceptAm(fluid.copy(), acc), pr);
                if (stack != null) {
                    acc.fill(stack, true);
                }
            } else {
                if (stack.amount >= n || (n = this.acceptAm(stack, acc)) <= 0) continue;
                if ((n = ((WarpPipeNetwork)this.pipe.network).extractFluid(stack, n, pr)) > 0) {
                    stack.amount = n;
                    acc.fill(stack, true);
                }
            }
            this.slotIdx = (i + 1) % m;
            return true;
        }
        return true;
    }

    private int acceptAm(FluidStack fluid, IFluidHandler acc) {
        fluid.amount = 65536;
        int n = acc.fill(fluid, false);
        if (n <= 0) {
            return 0;
        }
        if (this.filter == null || this.filter.noEffect()) {
            return n;
        }
        fluid.amount = n;
        return this.filter.insertAmount((Object)fluid, (Object)acc);
    }

    @Override
    protected ItemStack moduleItem() {
        return new ItemStack((Item)Objects.fluid_pipe, 1, 1);
    }
}

