/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.item;

import cd4017be.indlog.item.ItemFilteredSubInventory;
import cd4017be.indlog.render.gui.GuiRemoteInventory;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.GlitchSaveSlot;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.Gui.SlotItemType;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.capability.BasicInventory;
import cd4017be.lib.capability.InventoryItem;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.lib.util.Utils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemRemoteInv
extends ItemFilteredSubInventory {
    public static int INTERVAL = 20;
    public static int MAX_SLOTS = 48;

    public ItemRemoteInv(String id) {
        super(id);
        this.func_77625_d(1);
    }

    @Override
    protected int tickTime() {
        return INTERVAL;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, @Nullable World player, List<String> list, ITooltipFlag b) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt != null) {
            list.add(TooltipUtil.formatLink((BlockPos)BlockPos.func_177969_a((long)nbt.func_74763_f("pos")), (EnumFacing)EnumFacing.func_82600_a((int)nbt.func_74771_c("s")), (int)nbt.func_74762_e("d")));
        }
        super.func_77624_a(item, player, list, b);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing s, float X, float Y, float Z) {
        IItemHandler acc;
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack item = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        IItemHandler iItemHandler = acc = te != null ? (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, s) : null;
        if (acc == null) {
            player.func_145747_a((ITextComponent)new TextComponentString(TooltipUtil.translate((String)"gui.cd4017be.remote.invalid")));
            return EnumActionResult.SUCCESS;
        }
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            item.func_77982_d(nbt);
        }
        nbt.func_74772_a("pos", pos.func_177986_g());
        nbt.func_74774_a("s", (byte)s.func_176745_a());
        nbt.func_74768_a("d", player.field_71093_bK);
        player.func_145747_a((ITextComponent)new TextComponentString(TooltipUtil.translate((String)"gui.cd4017be.remote.linked")));
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (!player.func_70093_af() && !world.field_72995_K) {
            IItemHandler acc = (IItemHandler)item.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            BlockGuiHandler.openGui((EntityPlayer)player, (World)world, (BlockPos)new BlockPos(acc == null ? 0 : acc.getSlots(), -1, 0), (int)(hand == EnumHand.MAIN_HAND ? player.field_71071_by.field_70461_c : 40));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public Container getContainer(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new TileContainer((DataContainer.IGuiData)new GuiData(pos.func_177958_n()), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new GuiRemoteInventory((TileContainer)this.getContainer(item, player, world, pos, slot));
    }

    @Override
    protected void customPlayerCommand(ItemStack item, EntityPlayer player, byte cmd, PacketBuffer dis) {
        if (cmd == 2 && player.field_71070_bA instanceof TileContainer) {
            for (Slot s : player.field_71070_bA.field_75151_b) {
                if (!(s instanceof GlitchSaveSlot)) continue;
                player.field_71070_bA.field_75153_a.set(s.field_75222_d, (Object)ItemStack.field_190927_a);
            }
            Arrays.fill(((TileContainer)player.field_71070_bA).refInts, 0);
        } else if (cmd == 3) {
            NBTTagCompound nbt = item.func_77978_p();
            if (nbt == null) {
                return;
            }
            int offset = dis.readInt();
            if (offset < 0) {
                offset = 0;
            }
            nbt.func_74768_a("ofs", offset);
            if (player.field_71070_bA instanceof TileContainer) {
                TileContainer cont = (TileContainer)player.field_71070_bA;
                if (cont.data instanceof GuiData) {
                    GuiData data = (GuiData)cont.data;
                    data.offset = offset;
                }
            }
        }
    }

    public static TileEntity getLink(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        int d = nbt.func_74762_e("d");
        WorldServer world = DimensionManager.getWorld((int)d);
        if (world == null) {
            return null;
        }
        return Utils.getTileAt((World)world, (BlockPos)BlockPos.func_177969_a((long)nbt.func_74763_f("pos")));
    }

    public class CapabilityProvider
    implements ICapabilityProvider {
        public final ItemStack holder;

        public CapabilityProvider(ItemStack holder) {
            this.holder = holder;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return false;
            }
            TileEntity te = ItemRemoteInv.getLink(this.holder.func_77978_p());
            return te != null && te.hasCapability(cap, facing);
        }

        public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
            if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return null;
            }
            NBTTagCompound nbt = this.holder.func_77978_p();
            TileEntity te = ItemRemoteInv.getLink(nbt);
            if (te == null) {
                return null;
            }
            return (T)te.getCapability(cap, EnumFacing.field_82609_l[(nbt.func_74771_c("s") & 0xFF) % 6]);
        }
    }

    public class GuiData
    extends ItemGuiData
    implements IItemHandler {
        public TileEntity link;
        public IItemHandler linkedInv;
        public final int size;
        public final int ofsY;
        public int offset;
        public int slots;

        public GuiData(int size) {
            super((Item)ItemRemoteInv.this);
            if (size > MAX_SLOTS) {
                size = MAX_SLOTS;
            } else if (size < 12 && size != 0) {
                size = 12;
            }
            this.size = size;
            this.ofsY = (size - 1) / 12 * 18 - 18;
        }

        public void initContainer(DataContainer container) {
            TileContainer cont = (TileContainer)container;
            this.inv = new InventoryItem(cont.player);
            ItemStack item = (ItemStack)cont.player.field_71071_by.field_70462_a.get(cont.player.field_71071_by.field_70461_c);
            Object inventory = null;
            if (!cont.player.field_70170_p.field_72995_K) {
                NBTTagCompound nbt = item.func_77978_p();
                this.link = ItemRemoteInv.getLink(nbt);
                IItemHandler iItemHandler = this.linkedInv = this.link != null ? (IItemHandler)this.link.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[(nbt.func_74771_c("s") & 0xFF) % 6]) : null;
                if (this.linkedInv != null && (this.linkedInv == cont.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) || this.linkedInv == cont.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH) || this.linkedInv == cont.player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))) {
                    cont.player.func_145747_a((ITextComponent)new TextComponentString(TooltipUtil.translate((String)"gui.cd4017be.remote.selfAcc")));
                    this.link = null;
                }
                if (this.linkedInv != null) {
                    inventory = this;
                    this.slots = this.linkedInv.getSlots();
                    this.offset = Math.max(0, Math.min(nbt.func_74762_e("ofs"), this.slots - this.size));
                }
            } else if (this.size > 0) {
                inventory = new BasicInventory(this.size);
                this.linkedInv = inventory;
                PacketBuffer dos = BlockGuiHandler.getPacketForItem((int)cont.player.field_71071_by.field_70461_c);
                dos.writeByte(2);
                BlockGuiHandler.sendPacketToServer((PacketBuffer)dos);
            }
            if (inventory == null) {
                inventory = new BasicInventory(0);
                this.linkedInv = inventory;
            }
            cont.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inv, 0, 8, 86 + this.ofsY, ItemFilteredSubInventory.FILTER_SLOT));
            cont.addItemSlot((Slot)new SlotItemType((IItemHandler)this.inv, 1, 26, 86 + this.ofsY, ItemFilteredSubInventory.FILTER_SLOT));
            if (this.size > 0) {
                int h = this.size / 12;
                int w = this.size % 12;
                for (int j = 0; j < h; ++j) {
                    for (int i = 0; i < 12; ++i) {
                        cont.addItemSlot((Slot)new GlitchSaveSlot((IItemHandler)inventory, i + 12 * j, 8 + i * 18, 16 + j * 18, false));
                    }
                }
                for (int i = 0; i < w; ++i) {
                    cont.addItemSlot((Slot)new GlitchSaveSlot((IItemHandler)inventory, i + 12 * h, 8 + i * 18, 16 + h * 18, false));
                }
            }
            cont.addPlayerInventory(62, 68 + this.ofsY, false, true);
        }

        public int[] getSyncVariables() {
            int[] nArray = new int[2];
            this.slots = this.linkedInv == null ? 0 : this.linkedInv.getSlots();
            nArray[0] = this.slots;
            nArray[1] = this.offset;
            return nArray;
        }

        public void setSyncVariable(int i, int v) {
            switch (i) {
                case 0: {
                    this.slots = v;
                    break;
                }
                case 1: {
                    this.offset = v;
                }
            }
        }

        public boolean canPlayerAccessUI(EntityPlayer player) {
            ItemStack item = (ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c);
            if (player.field_70128_L || item.func_77973_b() != this.item || !item.func_77942_o()) {
                return false;
            }
            if (this.size == 0) {
                return true;
            }
            if (this.link == null || this.link != Utils.getTileAt((World)this.link.func_145831_w(), (BlockPos)this.link.func_174877_v())) {
                return false;
            }
            IItemHandler acc = (IItemHandler)this.link.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[(item.func_77978_p().func_74771_c("s") & 0xFF) % 6]);
            if (acc == null) {
                return false;
            }
            this.linkedInv = acc;
            if (acc.getSlots() - this.size <= 0) {
                this.offset = 0;
            }
            return true;
        }

        public int getSlots() {
            return this.size;
        }

        public ItemStack getStackInSlot(int slot) {
            return (slot += this.offset) < this.linkedInv.getSlots() ? this.linkedInv.getStackInSlot(slot) : ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if ((slot += this.offset) < this.linkedInv.getSlots()) {
                return this.linkedInv.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if ((slot += this.offset) < this.linkedInv.getSlots()) {
                return this.linkedInv.extractItem(slot, amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return (slot += this.offset) < this.linkedInv.getSlots() ? this.linkedInv.getSlotLimit(slot) : 0;
        }
    }
}

