/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.item;

import cd4017be.api.indlog.filter.ItemFilterProvider;
import cd4017be.indlog.filter.PipeFilterItem;
import cd4017be.indlog.render.gui.GuiItemFilter;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.IGuiItem;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.Gui.SlotHolo;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.capability.InventoryItem;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ItemItemFilter
extends BaseItem
implements IGuiItem,
BlockGuiHandler.ClientItemPacketReceiver,
InventoryItem.IItemInventory,
ItemFilterProvider {
    public ItemItemFilter(String id) {
        super(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, @Nullable World player, List<String> list, ITooltipFlag b) {
        if (item.func_77942_o()) {
            String s;
            String[] states = TooltipUtil.translate((String)"gui.cd4017be.filter.state").split(",");
            PipeFilterItem filter = this.getItemFilter(item);
            if (states.length >= 8) {
                s = states[(filter.mode & 1) == 0 ? 0 : 1];
                if ((filter.mode & 4) != 0) {
                    s = s + states[2];
                }
                if ((filter.mode & 8) != 0) {
                    s = s + states[3];
                }
                if ((filter.mode & 0x10) != 0) {
                    s = s + states[4];
                }
                if ((filter.mode & 2) != 0) {
                    s = s + states[5];
                }
                if ((filter.mode & 0x40) != 0) {
                    s = s + states[(filter.mode & 0x80) != 0 ? 7 : 6];
                }
            } else {
                s = "<invalid lang entry!>";
            }
            list.add(s);
            boolean num = (filter.mode & 0x20) != 0;
            for (ItemStack stack : filter.list) {
                list.add((num ? stack.func_190916_E() + "x " : "> ") + stack.func_82833_r());
            }
            if (filter.priority != 0) {
                list.add(TooltipUtil.format((String)"gui.cd4017be.priority", (Object[])new Object[]{filter.priority}));
            }
        }
        super.func_77624_a(item, player, list, b);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        BlockGuiHandler.openItemGui((EntityPlayer)player, (EnumHand)hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public Container getContainer(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new TileContainer((DataContainer.IGuiData)new GuiData(), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new GuiItemFilter(new TileContainer((DataContainer.IGuiData)new GuiData(), player));
    }

    public void onPacketFromClient(PacketBuffer dis, EntityPlayer player, ItemStack item, int slot) throws IOException {
        NBTTagCompound nbt;
        if (item.func_77942_o()) {
            nbt = item.func_77978_p();
        } else {
            nbt = new NBTTagCompound();
            item.func_77982_d(nbt);
        }
        byte cmd = dis.readByte();
        if (cmd == 0) {
            nbt.func_74774_a("mode", dis.readByte());
        } else if (cmd == 1) {
            nbt.func_74774_a("prior", dis.readByte());
        } else if (cmd == 2) {
            nbt.func_82580_o("ItIdx");
        }
    }

    public ItemStack[] loadInventory(ItemStack inv, EntityPlayer player) {
        Object[] items = new ItemStack[12];
        if (inv.func_77942_o()) {
            ItemFluidUtil.loadItems((NBTTagList)inv.func_77978_p().func_150295_c("Items", 10), (ItemStack[])items);
        } else {
            Arrays.fill(items, ItemStack.field_190927_a);
        }
        return items;
    }

    public void saveInventory(ItemStack inv, EntityPlayer player, ItemStack[] items) {
        if (!inv.func_77942_o()) {
            inv.func_77982_d(new NBTTagCompound());
        }
        inv.func_77978_p().func_74782_a("Items", (NBTBase)ItemFluidUtil.saveItems((ItemStack[])items));
    }

    public PipeFilterItem getItemFilter(ItemStack stack) {
        PipeFilterItem filter = new PipeFilterItem();
        if (stack != null && stack.func_77942_o()) {
            filter.deserializeNBT(stack.func_77978_p());
        }
        return filter;
    }

    class GuiData
    extends ItemGuiData {
        public GuiData() {
            super((Item)ItemItemFilter.this);
        }

        public void initContainer(DataContainer container) {
            TileContainer cont = (TileContainer)container;
            this.inv = new InventoryItem(cont.player);
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 6; ++i) {
                    cont.addItemSlot((Slot)new SlotHolo((IItemHandler)this.inv, j * 6 + i, 8 + i * 18, 16 + j * 18, false, true));
                }
            }
            cont.addPlayerInventory(8, 68, false, true);
        }
    }
}

