/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.item;

import cd4017be.api.indlog.filter.FluidFilterProvider;
import cd4017be.indlog.filter.PipeFilterFluid;
import cd4017be.indlog.render.gui.GuiFluidFilter;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.IGuiItem;
import cd4017be.lib.Gui.ITankContainer;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.Gui.TileContainer;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidFilter
extends BaseItem
implements IGuiItem,
BlockGuiHandler.ClientItemPacketReceiver,
FluidFilterProvider {
    public ItemFluidFilter(String id) {
        super(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, @Nullable World player, List<String> list, ITooltipFlag b) {
        if (item.func_77942_o()) {
            String s;
            String[] states = TooltipUtil.translate((String)"gui.cd4017be.filter.state").split(",");
            PipeFilterFluid filter = this.getFluidFilter(item);
            if (states.length >= 8) {
                s = states[(filter.mode & 1) == 0 ? 0 : 1];
                if ((filter.mode & 2) != 0) {
                    s = s + states[5];
                }
                if ((filter.mode & 4) != 0) {
                    s = s + states[(filter.mode & 8) != 0 ? 7 : 6];
                }
            } else {
                s = "<invalid lang entry!>";
            }
            list.add(s);
            for (Fluid stack : filter.list) {
                list.add("> " + stack.getLocalizedName(new FluidStack(stack, 0)));
            }
            if (filter.maxAmount != 0) {
                list.add(TooltipUtil.format((String)"gui.cd4017be.filter.stock", (Object[])new Object[]{TooltipUtil.formatNumber((double)((double)filter.maxAmount / 1000.0), (int)3)}));
            }
            if (filter.priority != 0) {
                list.add(TooltipUtil.format((String)"gui.cd4017be.priority", (Object[])new Object[]{filter.priority}));
            }
        }
        super.func_77624_a(item, player, list, b);
    }

    public Fluid[] getFluids(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("Fluids", 9)) {
            return null;
        }
        NBTTagList list = nbt.func_150295_c("Fluids", 8);
        Fluid[] fluids = new Fluid[list.func_74745_c()];
        for (int i = 0; i < fluids.length; ++i) {
            fluids[i] = FluidRegistry.getFluid((String)list.func_150307_f(i));
        }
        return fluids;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        BlockGuiHandler.openItemGui((EntityPlayer)player, (EnumHand)hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public Container getContainer(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new TileContainer((DataContainer.IGuiData)new GuiData(), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new GuiFluidFilter(new TileContainer((DataContainer.IGuiData)new GuiData(), player));
    }

    public void onPacketFromClient(PacketBuffer dis, EntityPlayer player, ItemStack item, int slot) throws IOException {
        NBTTagList list;
        NBTTagCompound nbt;
        if (item.func_77942_o()) {
            nbt = item.func_77978_p();
        } else {
            nbt = new NBTTagCompound();
            item.func_77982_d(nbt);
        }
        byte cmd = dis.readByte();
        switch (cmd) {
            case 5: {
                nbt.func_74774_a("mode", dis.readByte());
                return;
            }
            case 6: {
                nbt.func_74768_a("maxAm", dis.readInt());
                return;
            }
            case 7: {
                nbt.func_74774_a("prior", dis.readByte());
                return;
            }
        }
        if (cmd < 0 || cmd >= 5) {
            return;
        }
        String name = dis.func_150789_c(32);
        if (nbt.func_150297_b("Fluids", 9)) {
            list = nbt.func_150295_c("Fluids", 8);
        } else {
            list = new NBTTagList();
            nbt.func_74782_a("Fluids", (NBTBase)list);
        }
        if (!name.isEmpty()) {
            if (cmd < list.func_74745_c()) {
                list.func_150304_a((int)cmd, (NBTBase)new NBTTagString(name));
            } else {
                list.func_74742_a((NBTBase)new NBTTagString(name));
            }
        } else if (cmd < list.func_74745_c()) {
            list.func_74744_a((int)cmd);
        }
    }

    public PipeFilterFluid getFluidFilter(ItemStack stack) {
        PipeFilterFluid filter = new PipeFilterFluid();
        if (stack != null && stack.func_77942_o()) {
            filter.deserializeNBT(stack.func_77978_p());
        }
        return filter;
    }

    class GuiData
    extends ItemGuiData
    implements ITankContainer {
        private InventoryPlayer player;

        public GuiData() {
            super((Item)ItemFluidFilter.this);
        }

        public void initContainer(DataContainer container) {
            TileContainer cont = (TileContainer)container;
            for (int i = 0; i < this.getTanks(); ++i) {
                cont.addTankSlot(new TileContainer.TankSlot((ITankContainer)this, i, 26 + 18 * i, 16, 17));
            }
            cont.addPlayerInventory(8, 50, false, true);
            this.player = cont.player.field_71071_by;
        }

        public int getTanks() {
            return 5;
        }

        public FluidStack getTank(int i) {
            ItemStack item = (ItemStack)this.player.field_70462_a.get(this.player.field_70461_c);
            Fluid[] fluids = item != null ? ItemFluidFilter.this.getFluids(item.func_77978_p()) : null;
            return fluids != null && i < fluids.length ? new FluidStack(fluids[i], 0) : null;
        }

        public int getCapacity(int i) {
            return 0;
        }

        public void setTank(int i, FluidStack fluid) {
        }
    }
}

