/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.item;

import cd4017be.api.indlog.filter.FluidFilterProvider;
import cd4017be.api.indlog.filter.ItemFilterProvider;
import cd4017be.indlog.filter.AmountFilter;
import cd4017be.indlog.render.gui.GuiAmountFilter;
import cd4017be.lib.BlockGuiHandler;
import cd4017be.lib.Gui.DataContainer;
import cd4017be.lib.Gui.IGuiItem;
import cd4017be.lib.Gui.ItemGuiData;
import cd4017be.lib.item.BaseItem;
import cd4017be.lib.util.TooltipUtil;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAmountFilter
extends BaseItem
implements IGuiItem,
BlockGuiHandler.ClientItemPacketReceiver,
ItemFilterProvider,
FluidFilterProvider {
    public ItemAmountFilter(String id) {
        super(id);
    }

    public void func_77624_a(ItemStack item, @Nullable World player, List<String> list, ITooltipFlag b) {
        if (item.func_77942_o()) {
            String[] states = TooltipUtil.translate((String)"gui.cd4017be.filter.state").split(",");
            AmountFilter.FluidFilter filter = this.getFluidFilter(item);
            String s = TooltipUtil.format((String)"gui.cd4017be.filter.am", (Object[])new Object[]{filter.amount}) + " ";
            if (states.length >= 8) {
                if ((filter.mode & 2) != 0) {
                    s = s + states[5];
                }
                if ((filter.mode & 0x80) != 0) {
                    s = s + states[(filter.mode & 0x40) != 0 ? 7 : 6];
                }
            } else {
                s = s + "<invalid lang entry!>";
            }
            list.add(s);
            if (filter.priority != 0) {
                list.add(TooltipUtil.format((String)"gui.cd4017be.priority", (Object[])new Object[]{filter.priority}));
            }
        }
        super.func_77624_a(item, player, list, b);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        BlockGuiHandler.openItemGui((EntityPlayer)player, (EnumHand)hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public Container getContainer(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new DataContainer((DataContainer.IGuiData)new ItemGuiData((Item)this), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(ItemStack item, EntityPlayer player, World world, BlockPos pos, int slot) {
        return new GuiAmountFilter(new DataContainer((DataContainer.IGuiData)new ItemGuiData((Item)this), player));
    }

    public void onPacketFromClient(PacketBuffer dis, EntityPlayer player, ItemStack item, int slot) throws IOException {
        NBTTagCompound nbt;
        if (item.func_77942_o()) {
            nbt = item.func_77978_p();
        } else {
            nbt = new NBTTagCompound();
            item.func_77982_d(nbt);
        }
        byte cmd = dis.readByte();
        switch (cmd) {
            case 5: {
                nbt.func_74774_a("mode", dis.readByte());
                return;
            }
            case 6: {
                nbt.func_74768_a("amount", dis.readInt());
                return;
            }
            case 7: {
                nbt.func_74774_a("prior", dis.readByte());
                return;
            }
        }
    }

    public AmountFilter.FluidFilter getFluidFilter(ItemStack stack) {
        AmountFilter.FluidFilter filter = new AmountFilter.FluidFilter();
        if (stack != null && stack.func_77942_o()) {
            filter.deserializeNBT(stack.func_77978_p());
        }
        return filter;
    }

    public AmountFilter.ItemFilter getItemFilter(ItemStack stack) {
        AmountFilter.ItemFilter filter = new AmountFilter.ItemFilter();
        if (stack != null && stack.func_77942_o()) {
            filter.deserializeNBT(stack.func_77978_p());
        }
        return filter;
    }
}

