/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.filter;

import cd4017be.api.indlog.filter.FilterBase;
import cd4017be.indlog.Objects;
import cd4017be.lib.util.ItemFluidUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public abstract class NameFilter<Obj, Inv>
extends FilterBase<Obj, Inv> {
    public String regex;
    Pattern pattern;

    public boolean noEffect() {
        return false;
    }

    public Item item() {
        return Objects.name_filter;
    }

    public boolean transfer(Obj obj) {
        return (this.mode & 2) == 0 || !this.matches(obj);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74778_a("regex", this.regex);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.regex = nbt.func_74779_i("regex");
        try {
            this.pattern = Pattern.compile(this.regex);
        }
        catch (PatternSyntaxException e) {
            this.regex = Pattern.quote(this.regex);
            this.pattern = Pattern.compile(this.regex);
            this.mode = (byte)(this.mode | 0x10);
        }
    }

    public static class FluidFilter
    extends NameFilter<FluidStack, IFluidHandler> {
        public boolean matches(FluidStack obj) {
            String name;
            name = (this.mode & 4) == 0 ? (name = obj.getLocalizedName()) : obj.getFluid().getName();
            Matcher m = this.pattern.matcher(name);
            return ((this.mode & 8) == 0 ? m.find() : m.matches()) ^ (this.mode & 1) != 0;
        }

        public int insertAmount(FluidStack obj, IFluidHandler inv) {
            return this.matches(obj) ? obj.amount : 0;
        }

        public FluidStack getExtract(FluidStack obj, IFluidHandler inv) {
            if (obj != null) {
                return this.matches(obj) ? obj : null;
            }
            for (IFluidTankProperties prop : ItemFluidUtil.listTanks((IFluidHandler)inv)) {
                obj = prop.getContents();
                if (obj == null || !prop.canDrainFluidType(obj) || !this.matches(obj)) continue;
                return obj;
            }
            return null;
        }
    }

    public static class ItemFilter
    extends NameFilter<ItemStack, IItemHandler> {
        public boolean matches(ItemStack obj) {
            String name;
            if ((this.mode & 4) == 0) {
                name = obj.func_82833_r();
                int i = name.indexOf(167);
                while (i >= 0) {
                    name = name.substring(0, i) + (i >= name.length() - 2 ? "" : name.substring(i + 2));
                    i = name.indexOf(167, i);
                }
            } else {
                name = obj.func_77973_b().getRegistryName() + (obj.func_77981_g() ? "#" + obj.func_77960_j() : "");
            }
            Matcher m = this.pattern.matcher(name);
            return ((this.mode & 8) == 0 ? m.find() : m.matches()) ^ (this.mode & 1) != 0;
        }

        public int insertAmount(ItemStack obj, IItemHandler inv) {
            return this.matches(obj) ? obj.func_190916_E() : 0;
        }

        public ItemStack getExtract(ItemStack obj, IItemHandler inv) {
            int n = obj.func_190916_E();
            if (n > 0) {
                return this.matches(obj) ? obj : ItemStack.field_190927_a;
            }
            int m = inv.getSlots();
            for (int i = 0; i < m; ++i) {
                obj = inv.getStackInSlot(i);
                if (obj.func_190916_E() <= 0 || !this.matches(obj)) continue;
                return obj;
            }
            return ItemStack.field_190927_a;
        }
    }
}

