/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.filter;

import cd4017be.api.indlog.filter.FilterBase;
import cd4017be.indlog.Objects;
import cd4017be.lib.util.ItemFluidUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class ItemPropertyFilter
extends FilterBase<ItemStack, IItemHandler> {
    public float reference;

    public boolean matches(ItemStack obj) {
        float val;
        boolean frac = (this.mode & 0x10) != 0;
        switch (this.mode & 0xC) {
            case 0: {
                if (frac) {
                    val = 1.0f - (float)obj.func_77952_i() / (float)obj.func_77958_k();
                    break;
                }
                val = obj.func_77958_k() - obj.func_77952_i();
                break;
            }
            case 4: {
                IEnergyStorage acc = (IEnergyStorage)obj.getCapability(CapabilityEnergy.ENERGY, null);
                float f = val = acc == null ? 0.0f : (float)acc.getEnergyStored();
                if (!frac) break;
                val /= acc == null ? 0.0f : (float)acc.getMaxEnergyStored();
                break;
            }
            case 8: {
                IFluidHandlerItem acc = (IFluidHandlerItem)obj.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                int am = 0;
                int cap = 0;
                if (acc != null) {
                    for (IFluidTankProperties prop : ItemFluidUtil.listTanks((IFluidHandler)acc)) {
                        FluidStack stack = prop.getContents();
                        if (stack != null) {
                            am += stack.amount;
                        }
                        cap += prop.getCapacity();
                    }
                }
                val = am;
                if (!frac) break;
                val /= (float)cap;
                break;
            }
            default: {
                return true;
            }
        }
        return val > this.reference ^ (this.mode & 1) != 0;
    }

    public boolean noEffect() {
        return false;
    }

    public Item item() {
        return Objects.property_filter;
    }

    public int insertAmount(ItemStack obj, IItemHandler inv) {
        return this.matches(obj) ? obj.func_190916_E() : 0;
    }

    public ItemStack getExtract(ItemStack obj, IItemHandler inv) {
        if (obj.func_190916_E() > 0) {
            return this.matches(obj) ? obj : ItemStack.field_190927_a;
        }
        int n = inv.getSlots();
        for (int i = 0; i < n; ++i) {
            obj = inv.getStackInSlot(i);
            if (obj.func_190916_E() <= 0 || !this.matches(obj)) continue;
            return obj;
        }
        return ItemStack.field_190927_a;
    }

    public boolean transfer(ItemStack obj) {
        return (this.mode & 2) == 0 || !this.matches(obj);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74776_a("ref", this.reference);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.reference = nbt.func_74760_g("ref");
        super.deserializeNBT(nbt);
    }
}

