/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.entity;

import com.girafi.waddles.Waddles;
import com.girafi.waddles.init.WaddlesSounds;
import com.girafi.waddles.utils.ConfigurationHandler;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityAdeliePenguin
extends EntityAnimal {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()).func_77973_b(), new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()).func_77973_b()});
    public short rotationFlipper;
    private boolean moveFlipper = false;

    public EntityAdeliePenguin(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.95f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIExtinguishFire());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.5));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPolarBear.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityAdeliePenguin.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.16);
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? WaddlesSounds.ADELIE_BABY_AMBIENT : WaddlesSounds.ADELIE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return WaddlesSounds.ADELIE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WaddlesSounds.ADELIE_DEATH;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70161_v != this.field_70166_s && this.moveFlipper) {
            this.rotationFlipper = (short)(this.rotationFlipper + 1);
        }
    }

    protected int func_70693_a(EntityPlayer player) {
        if (ConfigurationHandler.dropExp) {
            return super.func_70693_a(player);
        }
        return 0;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Nullable
    public ResourceLocation func_184647_J() {
        if (ConfigurationHandler.dropFish) {
            return Waddles.LOOT_ENTITIES_PENGUIN_FISH;
        }
        return Waddles.EMPTY;
    }

    @Nonnull
    public EntityAdeliePenguin createChild(@Nonnull EntityAgeable ageable) {
        return new EntityAdeliePenguin(this.field_70170_p);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? 0.5f : 0.9f;
    }

    private class EntityAIExtinguishFire
    extends EntityAIPanic {
        EntityAIExtinguishFire() {
            super((EntityCreature)EntityAdeliePenguin.this, 2.0);
        }

        public boolean func_75250_a() {
            return (EntityAdeliePenguin.this.func_70631_g_() || EntityAdeliePenguin.this.func_70027_ad()) && super.func_75250_a();
        }
    }
}

