/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.tinkers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.gui.book.element.ElementImage;
import slimeknights.mantle.client.gui.book.element.ElementItem;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.content.ContentListing;
import slimeknights.tconstruct.library.book.content.ContentPageIconList;
import slimeknights.tconstruct.library.book.content.ContentSingleStatMultMaterial;
import slimeknights.tconstruct.library.book.sectiontransformer.SectionTransformer;
import slimeknights.tconstruct.library.materials.Material;

@SideOnly(value=Side.CLIENT)
public class YoyoMaterialSectionTransformer
extends SectionTransformer {
    private static final String[] MATERIAL_TYPES_ON_DISPLAY = new String[]{"body", "axle", "cord"};

    public YoyoMaterialSectionTransformer() {
        super("yoyomaterials");
    }

    public void transform(BookData book, SectionData data) {
        ContentListing listing = new ContentListing();
        listing.title = book.translate(this.sectionName);
        this.addPage(data, this.sectionName, "", (PageContent)listing);
        if (!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            return;
        }
        for (String type : MATERIAL_TYPES_ON_DISPLAY) {
            int pageIndex = data.pages.size();
            this.generateContent(type, data);
            if (pageIndex >= data.pages.size()) continue;
            listing.addEntry(this.getStatName(type), (PageData)data.pages.get(pageIndex));
        }
    }

    protected String getStatName(String type) {
        return Material.UNKNOWN.getStats(type).getLocalizedName();
    }

    protected List<ContentPageIconList> generateContent(String materialType, SectionData data) {
        List materialList = TinkerRegistry.getAllMaterials().stream().filter(m -> !m.isHidden()).filter(Material::hasItems).filter(material -> material.hasStats(materialType)).collect(Collectors.toList());
        if (materialList.size() == 0) {
            return ImmutableList.of();
        }
        List contentPages = ContentPageIconList.getPagesNeededForItemCount((int)materialList.size(), (SectionData)data, (String)this.getStatName(materialType));
        ListIterator iter = contentPages.listIterator();
        ContentPageIconList currentOverview = (ContentPageIconList)iter.next();
        contentPages.forEach(p -> {
            p.maxScale = 1.0f;
        });
        for (List materials : Lists.partition(materialList, (int)3)) {
            ContentSingleStatMultMaterial content = new ContentSingleStatMultMaterial(materials, materialType);
            String id = materialType + "_" + materials.stream().map(Material::getIdentifier).collect(Collectors.joining("_"));
            PageData page = this.addPage(data, id, "single_stat_material", (PageContent)content);
            for (Material material2 : materials) {
                Object icon = material2.getRepresentativeItem() != null ? new ElementItem(0, 0, 1.0f, material2.getRepresentativeItem()) : new ElementImage(ImageData.MISSING);
                if (currentOverview.addLink((SizedBookElement)icon, material2.getLocalizedNameColored(), page)) continue;
                currentOverview = (ContentPageIconList)iter.next();
            }
        }
        return contentPages;
    }
}

