/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.tinkers;

import com.jozufozu.yoyos.Yoyos;
import com.jozufozu.yoyos.common.EntityStickyYoyo;
import com.jozufozu.yoyos.common.EntityYoyo;
import com.jozufozu.yoyos.common.IYoyo;
import com.jozufozu.yoyos.common.ItemYoyo;
import com.jozufozu.yoyos.common.RenderOrientation;
import com.jozufozu.yoyos.tinkers.TinkersYoyos;
import com.jozufozu.yoyos.tinkers.materials.AxleMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.BodyMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.CordMaterialStats;
import com.jozufozu.yoyos.tinkers.materials.YoyoNBT;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.TinkerToolCore;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.library.utils.TooltipBuilder;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class YoyoCore
extends TinkerToolCore
implements IYoyo {
    public YoyoCore() {
        super(new PartMaterialType[]{new PartMaterialType((IToolPart)TinkersYoyos.YOYO_CORD, new String[]{"cord"}), new PartMaterialType((IToolPart)TinkersYoyos.YOYO_BODY, new String[]{"body"}), new PartMaterialType((IToolPart)TinkersYoyos.YOYO_BODY, new String[]{"body"}), new PartMaterialType((IToolPart)TinkersYoyos.YOYO_AXLE, new String[]{"axle"})});
        this.addCategory(new Category[]{Category.WEAPON, Category.NO_MELEE, Category.HARVEST, Category.PROJECTILE});
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            this.addDefaultSubItems((List)subItems, new Material[]{TinkerMaterials.string, null, null, null});
        }
    }

    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    public float damagePotential() {
        return 1.0f;
    }

    public double attackSpeed() {
        return 1.6;
    }

    protected ToolNBT buildTagData(List<Material> materials) {
        CordMaterialStats chord = (CordMaterialStats)materials.get(0).getStatsOrUnknown("cord");
        BodyMaterialStats side1 = (BodyMaterialStats)materials.get(1).getStatsOrUnknown("body");
        BodyMaterialStats side2 = (BodyMaterialStats)materials.get(2).getStatsOrUnknown("body");
        AxleMaterialStats core = (AxleMaterialStats)materials.get(3).getStatsOrUnknown("axle");
        YoyoNBT data = new YoyoNBT();
        data.side(side1, side2);
        data.core(core);
        data.chord(chord);
        return data;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        return false;
    }

    public List<String> getInformation(ItemStack stack, boolean detailed) {
        TooltipBuilder info = new TooltipBuilder(stack);
        YoyoNBT nbt = YoyoNBT.from(stack);
        info.addDurability(!detailed);
        info.addAttack();
        info.add(CordMaterialStats.formatLength(nbt.chordLength));
        if (nbt.duration < 0) {
            info.add(String.format("%s: %s%s", Util.translate((String)"stat.yoyo.duration.name", (Object[])new Object[0]), AxleMaterialStats.COLOR_Friction, Util.translate((String)"stat.yoyo.infinite.name", (Object[])new Object[0])) + TextFormatting.RESET);
        } else {
            info.add(String.format("%s: %s%s %s", Util.translate((String)"stat.yoyo.duration.name", (Object[])new Object[0]), AxleMaterialStats.COLOR_Friction, Util.df.format((float)nbt.duration / 20.0f), Util.translate((String)"stat.yoyo.duration.suffix", (Object[])new Object[0])) + TextFormatting.RESET);
        }
        info.add(BodyMaterialStats.formatWeight(nbt.weight));
        if (ToolHelper.getFreeModifiers((ItemStack)stack) > 0) {
            info.addFreeModifiers();
        }
        if (detailed) {
            info.addModifierInfo();
        }
        return info.getTooltip();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.isSticky(stack)) {
            tooltip.add("");
            tooltip.add(I18n.func_135052_a((String)"yoyos.info.sticky.name", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"yoyos.info.sticky.retraction.name", (Object[])new Object[]{new TextComponentKeybind("key.sneak").func_150260_c()}));
            tooltip.add(I18n.func_135052_a((String)"yoyos.info.sticky.release.name", (Object[])new Object[]{new TextComponentKeybind("key.jump").func_150260_c()}));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!worldIn.field_72995_K && !EntityYoyo.CASTERS.containsKey(playerIn) && ToolHelper.getCurrentDurability((ItemStack)itemStackIn) > 0) {
            EntityYoyo yoyo = this.isSticky(itemStackIn) ? new EntityStickyYoyo(worldIn, playerIn) : new EntityYoyo(worldIn, playerIn);
            worldIn.func_72838_d((Entity)yoyo);
            worldIn.func_184148_a(null, yoyo.field_70165_t, yoyo.field_70163_u, yoyo.field_70161_v, Yoyos.YOYO_THROW, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            playerIn.func_71020_j(0.05f);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean out = super.func_77644_a(stack, target, attacker);
        this.damageItem(stack, 1, attacker);
        return out;
    }

    public boolean isSticky(ItemStack yoyo) {
        NBTTagCompound root = TagUtil.getTagSafe((ItemStack)yoyo);
        return TinkerUtil.hasTrait((NBTTagCompound)root, (String)"sticky") || TinkerUtil.hasModifier((NBTTagCompound)root, (String)"gluey");
    }

    @SideOnly(value=Side.CLIENT)
    public Material getMaterialForPartForGuiRendering(int index) {
        switch (index) {
            case 0: {
                return ClientProxy.RenderMaterialString;
            }
            case 1: {
                return ClientProxy.RenderMaterials[2];
            }
            case 2: {
                return ClientProxy.RenderMaterials[1];
            }
            case 3: {
                return ClientProxy.RenderMaterials[0];
            }
        }
        return super.getMaterialForPartForGuiRendering(index);
    }

    @Override
    public float getWeight(ItemStack yoyo) {
        return YoyoNBT.from((ItemStack)yoyo).weight;
    }

    @Override
    public float getLength(ItemStack yoyo) {
        return YoyoNBT.from((ItemStack)yoyo).chordLength;
    }

    @Override
    public int getDuration(ItemStack yoyo) {
        return YoyoNBT.from((ItemStack)yoyo).duration;
    }

    @Override
    public int getAttackInterval(ItemStack yoyo) {
        return (int)Math.ceil(11.0 / Math.sqrt(ToolHelper.getActualAttackSpeed((ItemStack)yoyo))) + 1;
    }

    @Override
    public int getMaxCollectedDrops(ItemStack yoyo) {
        return ItemYoyo.calculateMaxCollectedDrops(new ModifierNBT((NBTTagCompound)TinkerUtil.getModifierTag((ItemStack)yoyo, (String)"collecting")).level);
    }

    @Override
    public void damageItem(ItemStack yoyo, int amount, EntityLivingBase player) {
        if (!(player instanceof EntityPlayer) || !((EntityPlayer)player).field_71075_bZ.field_75098_d) {
            ToolHelper.damageTool((ItemStack)yoyo, (int)1, (EntityLivingBase)player);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getCordColor(ItemStack yoyo, float ticks) {
        List materials = TinkerUtil.getMaterialsFromTagList((NBTTagList)TagUtil.getBaseMaterialsTagList((ItemStack)yoyo));
        return ((Material)materials.get((int)0)).materialTextColor;
    }

    @Override
    public void entityInteraction(ItemStack yoyo, EntityPlayer player, EnumHand hand, EntityYoyo yoyoEntity, Entity target) {
        if (ItemYoyo.collectItem(yoyo, player, hand, yoyoEntity, target)) {
            return;
        }
        NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)yoyo);
        int index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)"gardening");
        if (index != -1) {
            ItemYoyo.shearEntity(yoyo, player, hand, yoyoEntity, target);
            return;
        }
        ToolHelper.attackEntity((ItemStack)yoyo, (ToolCore)((ToolCore)yoyo.func_77973_b()), (EntityLivingBase)player, (Entity)target, (Entity)yoyoEntity);
    }

    @Override
    public boolean interactsWithBlocks(ItemStack yoyo) {
        NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)yoyo);
        int index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)"gardening");
        if (index != -1) {
            return true;
        }
        index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)"farming");
        return index != -1;
    }

    @Override
    public void blockInteraction(ItemStack yoyo, EntityPlayer player, World world, BlockPos pos, IBlockState state, Block block, EntityYoyo yoyoEntity) {
        NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)yoyo);
        int index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)"gardening");
        if (index != -1) {
            ItemYoyo.garden(yoyo, player, pos, state, block, yoyoEntity);
            return;
        }
        index = TinkerUtil.getIndexInCompoundList((NBTTagList)tagList, (String)"farming");
        if (index != -1) {
            ItemYoyo.farm(yoyo, player, pos, state, block, yoyoEntity);
            ItemYoyo.till(yoyo, player, pos, state, block, yoyoEntity);
        }
    }

    @Override
    public float getWaterMovementModifier(ItemStack yoyo) {
        NBTTagList tagList = TagUtil.getModifiersTagList((ItemStack)yoyo);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            ModifierNBT data = ModifierNBT.readTag((NBTTagCompound)tagList.func_150305_b(i));
            if (!data.identifier.matches("fins|aquadynamic")) continue;
            return 0.8f;
        }
        return 0.3f;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!EntityYoyo.CASTERS.containsKey(entityIn)) {
            super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        }
    }

    @Override
    public void onUpdate(ItemStack yoyo, EntityYoyo yoyoEntity) {
        int itemDamage = yoyo.func_77952_i();
        for (ITrait trait : TinkerUtil.getTraitsOrdered((ItemStack)yoyo)) {
            trait.onUpdate(yoyo, yoyoEntity.field_70170_p, (Entity)yoyoEntity, 0, true);
        }
        if (yoyoEntity.getThrower() instanceof EntityPlayer && ((EntityPlayer)yoyoEntity.getThrower()).func_184812_l_()) {
            yoyo.func_77964_b(itemDamage);
        }
        if (!yoyoEntity.isCollecting()) {
            return;
        }
        NBTTagList modifiersTagList = TagUtil.getModifiersTagList((ItemStack)yoyo);
        int index = TinkerUtil.getIndexInCompoundList((NBTTagList)modifiersTagList, (String)"magnetic");
        if (index == -1) {
            return;
        }
        ModifierNBT data = new ModifierNBT(modifiersTagList.func_150305_b(index));
        double x = yoyoEntity.field_70165_t;
        double y = yoyoEntity.field_70163_u;
        double z = yoyoEntity.field_70161_v;
        double range = 1.8 + (double)data.level * 0.3;
        List items = yoyoEntity.func_130014_f_().func_72872_a(EntityItem.class, new AxisAlignedBB(x - range, y - range, z - range, x + range, y + range, z + range));
        int pulled = 0;
        for (EntityItem item : items) {
            if (item.func_92059_d().func_190926_b() || item.field_70128_L) continue;
            if (pulled > 200) break;
            float strength = 0.07f;
            Vector3d vec = new Vector3d(x, y, z);
            vec.sub((Tuple3d)new Vector3d(item.field_70165_t, item.field_70163_u, item.field_70161_v));
            vec.normalize();
            vec.scale((double)strength);
            item.field_70159_w += vec.x;
            item.field_70181_x += vec.y;
            item.field_70179_y += vec.z;
            ++pulled;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderOrientation getRenderOrientation(ItemStack yoyo) {
        return TinkerUtil.getModifierTag((ItemStack)yoyo, (String)"gardening").func_82582_d() ? RenderOrientation.Vertical : RenderOrientation.Horizontal;
    }
}

