/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.compat;

import com.jozufozu.yoyos.Yoyos;
import com.jozufozu.yoyos.common.EntityYoyo;
import com.jozufozu.yoyos.network.MessageAcquireTarget;
import com.jozufozu.yoyos.network.YoyoNetwork;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.Vector3;

public class EntityChaserYoyo
extends EntityYoyo {
    private Entity target;
    private int ticksChasing;

    public EntityChaserYoyo(World world) {
        super(world);
    }

    public EntityChaserYoyo(World world, EntityPlayer player) {
        super(world, player);
    }

    public void setTargetEntity(@Nullable Entity target) {
        this.target = target;
    }

    public void forgetTargetEntity() {
        this.target = null;
        if (!this.field_70170_p.field_72995_K) {
            this.ticksChasing = 0;
            YoyoNetwork.INSTANCE.sendToAllTracking((IMessage)new MessageAcquireTarget.MessageTargetUpdate(this), (Entity)this);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.target != null) {
            this.particles();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.target != null) {
                if (this.ticksChasing++ > 20) {
                    this.forgetTargetEntity();
                }
            } else if (this.ticksChasing > 0) {
                this.ticksChasing = 0;
            }
        }
    }

    @Override
    public void interactWithEntity(Entity entity) {
        if (this.attackCool >= this.maxCool && entity == this.target) {
            this.forgetTargetEntity();
        }
        super.interactWithEntity(entity);
    }

    @Override
    public Vec3d getTarget() {
        if (this.target != null && !this.isRetracting && !this.target.field_70128_L) {
            return new Vec3d(this.target.field_70165_t, this.target.field_70163_u + (double)this.target.field_70131_O * 0.5, this.target.field_70161_v);
        }
        return super.getTarget();
    }

    @Override
    protected void handlePlayerPulling() {
        if (this.target == null) {
            super.handlePlayerPulling();
        }
    }

    public void acquireTargetEntity() {
        if (this.isRetracting) {
            return;
        }
        if (!ManaItemHandler.requestManaExact((ItemStack)this.yoyoStack, (EntityPlayer)this.thrower, (int)200, (boolean)false)) {
            return;
        }
        AxisAlignedBB searchBox = new AxisAlignedBB(this.thrower.field_70165_t - (double)this.maxLength, this.thrower.field_70163_u - (double)this.maxLength, this.thrower.field_70161_v - (double)this.maxLength, this.thrower.field_70165_t + (double)this.maxLength, this.thrower.field_70163_u + (double)this.maxLength, this.thrower.field_70161_v + (double)this.maxLength);
        Vec3d lookVec = this.thrower.func_70040_Z();
        Entity lastTarget = this.target;
        Entity bestTarget = null;
        double maxCloseness = 0.0;
        List chaseable = this.field_70170_p.func_175674_a((Entity)this, searchBox, entity -> this.isCollecting() && entity instanceof EntityItem || entity instanceof EntityLivingBase);
        for (Entity testEntity : chaseable) {
            Vec3d testVec;
            if (testEntity.field_70128_L || testEntity == this.thrower || testEntity instanceof EntityLivingBase && ((EntityLivingBase)testEntity).field_70725_aQ > 0 || (testVec = new Vec3d(testEntity.field_70165_t - this.thrower.field_70165_t, testEntity.field_70163_u - this.thrower.field_70163_u + (double)testEntity.field_70131_O * 0.5, testEntity.field_70161_v - this.thrower.field_70161_v)).func_189985_c() > (double)(this.maxLength * this.maxLength)) continue;
            double closeness = testVec.func_72432_b().func_72430_b(lookVec);
            if (testEntity instanceof EntityAnimal) {
                closeness *= 0.5;
            } else if (testEntity instanceof EntityItem) {
                closeness *= 0.7;
            } else if (!(testEntity instanceof EntityAmbientCreature)) {
                closeness *= 2.0;
            }
            if (!(closeness > maxCloseness) || !this.canEntityBeSeen(testEntity) || !this.thrower.func_70685_l(testEntity)) continue;
            maxCloseness = closeness;
            bestTarget = testEntity;
        }
        if (bestTarget != lastTarget) {
            this.target = bestTarget;
            ManaItemHandler.requestManaExact((ItemStack)this.yoyoStack, (EntityPlayer)this.thrower, (int)200, (boolean)true);
            this.field_70170_p.func_184148_a(null, this.thrower.field_70165_t, this.thrower.field_70163_u + (double)this.thrower.eyeHeight, this.thrower.field_70161_v, Yoyos.YOYO_CHASE, SoundCategory.PLAYERS, 0.4f, 1.2f + this.field_70170_p.field_73012_v.nextFloat() * 0.6f);
            YoyoNetwork.INSTANCE.sendToAllTracking((IMessage)new MessageAcquireTarget.MessageTargetUpdate(this, bestTarget), (Entity)this);
        }
    }

    private void particles() {
        if (this.field_70170_p.field_72995_K) {
            Color color = new Color(0x20FF20);
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            float osize = 0.4f;
            boolean monocle = Botania.proxy.isClientPlayerWearingMonocle();
            if (monocle) {
                Botania.proxy.setWispFXDepthTest(false);
            }
            if (ConfigHandler.subtlePowerSystem) {
                Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v, r, g, b, 0.1f * osize, (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.01f);
            } else {
                float size;
                float or = r;
                float og = g;
                float ob = b;
                double luminance = 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
                double savedPosX = this.field_70165_t;
                double savedPosY = this.field_70163_u;
                double savedPosZ = this.field_70161_v;
                Vector3 currentPos = Vector3.fromEntity((Entity)this);
                Vector3 oldPos = new Vector3(this.field_70169_q, this.field_70167_r, this.field_70166_s);
                Vector3 diffVec = oldPos.subtract(currentPos);
                Vector3 diffVecNorm = diffVec.normalize();
                double distance = 0.095;
                do {
                    if (luminance < 0.1) {
                        r = or + (float)Math.random() * 0.125f;
                        g = og + (float)Math.random() * 0.125f;
                        b = ob + (float)Math.random() * 0.125f;
                    }
                    size = osize + ((float)Math.random() - 0.5f) * 0.065f + (float)Math.sin(new Random(this.field_96093_i.getMostSignificantBits()).nextInt(9001)) * 0.4f;
                    Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v, r, g, b, 0.2f * size, (float)(-this.field_70159_w) * 0.01f, (float)(-this.field_70181_x) * 0.01f, (float)(-this.field_70179_y) * 0.01f);
                    this.field_70165_t += diffVecNorm.x * distance;
                    this.field_70163_u += diffVecNorm.y * distance;
                    this.field_70161_v += diffVecNorm.z * distance;
                    currentPos = Vector3.fromEntity((Entity)this);
                    diffVec = oldPos.subtract(currentPos);
                } while (!this.getEntityData().func_74764_b("orbit") && Math.abs(diffVec.mag()) > distance);
                Botania.proxy.wispFX(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v, or, og, ob, 0.1f * size, (float)(Math.random() - 0.5) * 0.06f, (float)(Math.random() - 0.5) * 0.06f, (float)(Math.random() - 0.5) * 0.06f);
                this.field_70165_t = savedPosX;
                this.field_70163_u = savedPosY;
                this.field_70161_v = savedPosZ;
            }
            if (monocle) {
                Botania.proxy.setWispFXDepthTest(true);
            }
        }
    }

    public boolean canEntityBeSeen(Entity entityIn) {
        return this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O * 0.5, this.field_70161_v), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), false, true, false) == null;
    }
}

