/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.yoyos.common;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="yoyos")
@Mod.EventBusSubscriber(modid="yoyos")
public class ModConfig {
    @Config.LangKey(value="yoyos.config.swing")
    @Config.Comment(value={"Allows you to swing from yoyos when they get caught."})
    public static boolean yoyoSwing = true;
    @Config.LangKey(value="yoyos.config.collecting_base")
    @Config.Comment(value={"How many items a yoyo enchanted with Collecting I can hold.", "Doubles with every level."})
    @Config.RangeInt(min=0)
    public static int collectingBase = 64;
    @Config.LangKey(value="yoyos.config.vanilla")
    public static VanillaYoyos vanillaYoyos = new VanillaYoyos();
    @Config.LangKey(value="yoyos.config.botania")
    public static BotaniaYoyos botaniaYoyos = new BotaniaYoyos();
    @Config.LangKey(value="yoyos.config.replanting")
    @Config.Comment(value={"Should farming yoyos replant crops"})
    public static boolean replant = true;
    @Config.LangKey(value="yoyos.config.tinkers")
    @Config.Comment(value={"Add customizable yoyos if Tinkers' Construct is installed."})
    @Config.RequiresMcRestart
    public static boolean tinkersYoyos = true;
    @Config.LangKey(value="yoyos.config.tinkers.tool_station")
    @Config.Comment(value={"Allows yoyos to be crafted in the Tinkers' Construct Tool Station."})
    @Config.RequiresMcRestart
    public static boolean stationCrafting = false;
    @Config.LangKey(value="yoyos.config.materials")
    @Config.Comment(value={"If enabled, saves materials into a config folder.", "Allows for editing, addition, and removal of stats for yoyos."})
    @Config.RequiresMcRestart
    public static boolean configMaterials = false;

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("yoyos".equals(event.getModID())) {
            ConfigManager.sync((String)"yoyos", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class YoyoSettings {
        @Config.LangKey(value="yoyos.config.weight")
        @Config.Comment(value={"Affects how fast the yoyo moves"})
        @Config.RangeDouble(min=0.0)
        public float weight;
        @Config.LangKey(value="yoyos.config.length")
        @Config.Comment(value={"How far away the yoyo can get (in blocks)"})
        @Config.RangeDouble(min=0.0)
        public float length;
        @Config.LangKey(value="yoyos.config.duration")
        @Config.Comment(value={"How long the yoyo can stay out (in ticks)", "-1 means infinite duration"})
        @Config.RangeInt(min=-1)
        public int duration;
        @Config.LangKey(value="yoyos.config.damage")
        @Config.Comment(value={"How much damage the yoyo does (in hearts)"})
        @Config.RangeDouble(min=0.0)
        public float damage;

        public YoyoSettings(float weight, float length, int duration, float damage) {
            this.weight = weight;
            this.length = length;
            this.duration = duration;
            this.damage = damage;
        }
    }

    public static class BotaniaYoyos {
        @Config.LangKey(value="yoyos.config.enable")
        @Config.Comment(value={"Integrate with botania if it is installed."})
        @Config.RequiresMcRestart
        public boolean enable = true;
        @Config.LangKey(value="yoyos.config.botania.hackery")
        @Config.Comment(value={"Merge the yoyo pages in the Lexica Botania with their normal counterparts.", "Disable if you notice any conflicts."})
        @Config.RequiresMcRestart
        public boolean lexiconHackery = true;
        @Config.LangKey(value="item.yoyos.manasteel_yoyo.name")
        public YoyoSettings manasteelYoyo = new YoyoSettings(5.0f, 8.0f, 300, 5.0f);
        @Config.LangKey(value="item.yoyos.elementium_yoyo.name")
        public YoyoSettings elementiumYoyo = new YoyoSettings(5.0f, 8.0f, 300, 5.0f);
        @Config.LangKey(value="item.yoyos.terrasteel_yoyo.name")
        public YoyoSettings terrasteelYoyo = new YoyoSettings(1.7f, 9.0f, 400, 6.0f);
    }

    public static class VanillaYoyos {
        @Config.LangKey(value="yoyos.config.enable")
        @Config.Comment(value={"Whether or not the default yoyos are added"})
        @Config.RequiresMcRestart
        public boolean enable = true;
        @Config.LangKey(value="item.yoyos.wooden_yoyo.name")
        public YoyoSettings woodenYoyo = new YoyoSettings(2.2f, 6.0f, 100, 3.0f);
        @Config.LangKey(value="item.yoyos.stone_yoyo.name")
        public YoyoSettings stoneYoyo = new YoyoSettings(4.0f, 7.0f, 200, 4.0f);
        @Config.LangKey(value="item.yoyos.iron_yoyo.name")
        public YoyoSettings ironYoyo = new YoyoSettings(5.0f, 8.0f, 300, 5.0f);
        @Config.LangKey(value="item.yoyos.shear_yoyo.name")
        public YoyoSettings shearYoyo = new YoyoSettings(5.1f, 8.0f, 300, 5.5f);
        @Config.LangKey(value="item.yoyos.gold_yoyo.name")
        public YoyoSettings goldYoyo = new YoyoSettings(5.5f, 11.0f, 600, 3.0f);
        @Config.LangKey(value="item.yoyos.diamond_yoyo.name")
        public YoyoSettings diamondYoyo = new YoyoSettings(1.7f, 9.0f, 400, 6.0f);
        @Config.LangKey(value="item.yoyos.hoe_yoyo.name")
        public YoyoSettings hoeYoyo = new YoyoSettings(2.2f, 9.0f, 400, 6.5f);
        @Config.LangKey(value="item.yoyos.sticky_yoyo.name")
        public YoyoSettings stickyYoyo = new YoyoSettings(1.8f, 9.0f, 400, 0.0f);
        @Config.LangKey(value="item.yoyos.creative_yoyo.name")
        public YoyoSettings creativeYoyo = new YoyoSettings(0.9f, 24.0f, -1, 9001.0f);
    }
}

