/*
 * Decompiled with CFR 0.152.
 */
package rustic.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Iterator;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import rustic.common.crafting.ICondenserRecipe;
import rustic.common.crafting.Recipes;
import rustic.compat.crafttweaker.CrTCondenserRecipe;
import rustic.compat.crafttweaker.CraftTweakerHelper;
import stanhebben.zenscript.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.rustic.Condenser")
public class Condenser {
    @ZenMethod
    public static void addRecipe(@NotNull IItemStack output, IIngredient input1, IIngredient input2) {
        CrTCondenserRecipe r = new CrTCondenserRecipe(CraftTweakerMC.getItemStack((IItemStack)output), new IIngredient[]{input1, input2});
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(@NotNull IItemStack output, IIngredient[] inputs) {
        if (inputs.length > 3) {
            throw new IllegalArgumentException("Condenser recipe has at most 3 inputs");
        }
        CrTCondenserRecipe r = new CrTCondenserRecipe(CraftTweakerMC.getItemStack((IItemStack)output), inputs);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(@NotNull IItemStack output, IIngredient[] inputs, IIngredient modifier) {
        if (inputs.length > 3) {
            throw new IllegalArgumentException("Condenser recipe has at most 3 inputs");
        }
        CrTCondenserRecipe r = new CrTCondenserRecipe(CraftTweakerMC.getItemStack((IItemStack)output), inputs, modifier);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(@NotNull IItemStack output, @NotNull IIngredient[] inputs, IIngredient modifier, IIngredient bottle) {
        if (inputs.length > 3) {
            throw new IllegalArgumentException("Condenser recipe has at most 3 inputs");
        }
        if (bottle == null) {
            bottle = CraftTweakerMC.getIItemStack((ItemStack)new ItemStack(Items.field_151069_bo));
        }
        CrTCondenserRecipe r = new CrTCondenserRecipe(CraftTweakerMC.getItemStack((IItemStack)output), inputs, modifier, bottle);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(@NotNull IItemStack output, @NotNull IIngredient[] inputs, IIngredient modifier, IIngredient bottle, ILiquidStack fluid) {
        if (inputs.length > 3) {
            throw new IllegalArgumentException("Condenser recipe has at most 3 inputs");
        }
        if (bottle == null) {
            bottle = CraftTweakerMC.getIItemStack((ItemStack)new ItemStack(Items.field_151069_bo));
        }
        if (fluid == null) {
            fluid = CraftTweakerMC.getILiquidStack((FluidStack)new FluidStack(FluidRegistry.WATER, 125));
        }
        CrTCondenserRecipe r = new CrTCondenserRecipe(CraftTweakerMC.getItemStack((IItemStack)output), inputs, modifier, bottle, CraftTweakerMC.getLiquidStack((ILiquidStack)fluid));
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void addRecipe(@NotNull IItemStack output, @NotNull IIngredient[] inputs, IIngredient modifier, IIngredient bottle, ILiquidStack fluid, int time) {
        if (inputs.length > 3) {
            throw new IllegalArgumentException("Condenser recipe has at most 3 inputs");
        }
        if (bottle == null) {
            bottle = CraftTweakerMC.getIItemStack((ItemStack)new ItemStack(Items.field_151069_bo));
        }
        if (fluid == null) {
            fluid = CraftTweakerMC.getILiquidStack((FluidStack)new FluidStack(FluidRegistry.WATER, 125));
        }
        if (time <= 0) {
            throw new IllegalArgumentException("Brew time must be positive");
        }
        CrTCondenserRecipe r = new CrTCondenserRecipe(CraftTweakerMC.getItemStack((IItemStack)output), inputs, modifier, bottle, CraftTweakerMC.getLiquidStack((ILiquidStack)fluid), time);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        if (!CraftTweakerHelper.toStack(output).func_190926_b()) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            Iterator<ICondenserRecipe> it = Recipes.condenserRecipes.iterator();
            while (it.hasNext()) {
                ICondenserRecipe r = it.next();
                if (r == null || r.getResult() == null || !ItemStack.func_77989_b((ItemStack)r.getResult(), (ItemStack)this.output)) continue;
                it.remove();
            }
        }

        public String describe() {
            return "Removing Condenser Recipes for Item " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final ICondenserRecipe recipe;

        public Add(ICondenserRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            Recipes.condenserRecipes.add(this.recipe);
        }

        public String describe() {
            return "Adding Alchemy Recipe for Item " + this.recipe.getResult().func_82833_r();
        }
    }
}

