/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.world;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import rustic.common.Config;
import rustic.common.blocks.ModBlocks;
import rustic.common.world.WorldGenIronwoodTree;
import rustic.common.world.WorldGenOliveTree;

public class WorldGenAllTrees
extends WorldGenerator {
    private WorldGenOliveTree olives = new WorldGenOliveTree(true);
    private WorldGenIronwoodTree ironwoods = new WorldGenIronwoodTree(true);

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        boolean ret = false;
        if (this.generateOliveTrees(world, rand, pos)) {
            ret = true;
        }
        if (this.generateIronwoodTrees(world, rand, pos)) {
            ret = true;
        }
        return ret;
    }

    private boolean generateOliveTrees(World world, Random rand, BlockPos pos) {
        boolean validBiome;
        boolean generated = false;
        Biome biome = world.func_180494_b(pos);
        boolean bl = validBiome = !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
        if (validBiome && rand.nextFloat() < Config.OLIVE_GEN_CHANCE) {
            for (int i = 0; i < Config.MAX_OLIVE_GEN_ATTEMPTS; ++i) {
                int z;
                int y;
                int x = pos.func_177958_n() + (5 - rand.nextInt(11));
                BlockPos genPos = new BlockPos(x, y = world.func_189649_b(x, z = pos.func_177952_p() + (5 - rand.nextInt(11))), z);
                if (world.func_175708_f(genPos, true) || !ModBlocks.SAPLING.func_176196_c(world, genPos) || !this.olives.func_180709_b(world, rand, genPos)) continue;
                generated = true;
            }
        }
        return generated;
    }

    private boolean generateIronwoodTrees(World world, Random rand, BlockPos pos) {
        boolean validBiome;
        boolean generated = false;
        Biome biome = world.func_180494_b(pos);
        boolean bl = validBiome = !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        if (validBiome && rand.nextFloat() < Config.IRONWOOD_GEN_CHANCE) {
            for (int i = 0; i < Config.MAX_IRONWOOD_GEN_ATTEMPTS; ++i) {
                int z;
                int y;
                int x = pos.func_177958_n() + (5 - rand.nextInt(11));
                BlockPos genPos = new BlockPos(x, y = world.func_189649_b(x, z = pos.func_177952_p() + (5 - rand.nextInt(11))), z);
                if (!ModBlocks.SAPLING.func_176196_c(world, genPos) || !this.ironwoods.func_180709_b(world, rand, genPos)) continue;
                generated = true;
            }
        }
        return generated;
    }
}

