/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.tileentities;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.TeslaEnergyLevelPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.EnergyStorage;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import net.ndrei.teslacorelib.tileentities.SyncTileEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u001a\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0016J\u001e\u0010&\u001a\u00020'2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010(\u001a\u00020)H\u0014J\u0006\u0010*\u001a\u00020)J\b\u0010+\u001a\u00020)H$R\u001a\u0010\u0005\u001a\u00020\u00068DX\u0085\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006-"}, d2={"Lnet/ndrei/teslacorelib/tileentities/ElectricTileEntity;", "Lnet/ndrei/teslacorelib/tileentities/SidedTileEntity;", "typeId", "", "(I)V", "energyBoundingBox", "Lnet/ndrei/teslacorelib/inventory/BoundingRectangle;", "energyBoundingBox$annotations", "()V", "getEnergyBoundingBox", "()Lnet/ndrei/teslacorelib/inventory/BoundingRectangle;", "energyInputRate", "", "getEnergyInputRate", "()J", "energyOutputRate", "getEnergyOutputRate", "<set-?>", "Lnet/ndrei/teslacorelib/inventory/EnergyStorage;", "energyStorage", "getEnergyStorage", "()Lnet/ndrei/teslacorelib/inventory/EnergyStorage;", "setEnergyStorage", "(Lnet/ndrei/teslacorelib/inventory/EnergyStorage;)V", "maxEnergy", "getMaxEnergy", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getGuiContainerPieces", "", "Lnet/ndrei/teslacorelib/gui/IGuiContainerPiece;", "container", "Lnet/ndrei/teslacorelib/gui/BasicTeslaGuiContainer;", "hasCapability", "", "initializeInventories", "", "innerUpdate", "protectedUpdate", "Companion", "tesla-core-lib"})
public abstract class ElectricTileEntity
extends SidedTileEntity {
    @NotNull
    private EnergyStorage energyStorage;
    @NotNull
    protected static final String SYNC_ENERGY = "energy";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final EnergyStorage getEnergyStorage() {
        EnergyStorage energyStorage = this.energyStorage;
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"energyStorage");
        }
        return energyStorage;
    }

    private final void setEnergyStorage(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    @Override
    protected void initializeInventories() {
        EnergyStorage energyStorage = this.energyStorage = (EnergyStorage)new EnergyStorage(this, this.getMaxEnergy(), this.getEnergyInputRate(), this.getEnergyOutputRate()){
            final /* synthetic */ ElectricTileEntity this$0;

            public void onChanged(long old, long current) {
                SyncTileEntity.partialSync$default(this.this$0, "energy", false, 2, null);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"energyStorage");
        }
        energyStorage.setSidedConfig(EnumDyeColor.LIGHT_BLUE, this.getSideConfig(), this.getEnergyBoundingBox());
        EnergyStorage energyStorage2 = this.energyStorage;
        if (energyStorage2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"energyStorage");
        }
        this.registerSyncTagPart(SYNC_ENERGY, (INBTSerializable<NBTTagCompound>)((INBTSerializable)energyStorage2), SyncProviderLevel.GUI);
        super.initializeInventories();
    }

    protected static /* synthetic */ void energyBoundingBox$annotations() {
    }

    @NotNull
    protected final BoundingRectangle getEnergyBoundingBox() {
        return new BoundingRectangle(7, 25, 18, 54);
    }

    protected long getMaxEnergy() {
        return 50000L;
    }

    protected long getEnergyInputRate() {
        return 80L;
    }

    protected long getEnergyOutputRate() {
        return 0L;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        EnumFacing oriented = this.orientFacing(facing);
        if (!this.isPaused()) {
            EnergyStorage energyStorage = this.energyStorage;
            if (energyStorage == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"energyStorage");
            }
            if (energyStorage.hasCapability(capability, oriented)) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        T c;
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        EnumFacing oriented = this.orientFacing(facing);
        EnergyStorage energyStorage = this.energyStorage;
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"energyStorage");
        }
        if ((c = energyStorage.getCapability(capability, oriented)) != null) {
            return c;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        BoundingRectangle energyBox = this.getEnergyBoundingBox();
        if (!energyBox.isEmpty()) {
            int n = energyBox.getLeft();
            int n2 = energyBox.getTop();
            EnergyStorage energyStorage = this.energyStorage;
            if (energyStorage == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"energyStorage");
            }
            pieces.add(new TeslaEnergyLevelPiece(n, n2, energyStorage));
        }
        return pieces;
    }

    @Override
    public final void innerUpdate() {
        this.protectedUpdate();
        EnergyStorage energyStorage = this.energyStorage;
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"energyStorage");
        }
        energyStorage.processStatistics();
    }

    protected abstract void protectedUpdate();

    protected ElectricTileEntity(int typeId) {
        super(typeId);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/ndrei/teslacorelib/tileentities/ElectricTileEntity$Companion;", "", "()V", "SYNC_ENERGY", "", "tesla-core-lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

