/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.tileentities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.modcrafters.mclib.energy.IGenericEnergyStorage;
import net.ndrei.teslacorelib.capabilities.inventory.SidedItemHandlerConfig;
import net.ndrei.teslacorelib.containers.BasicTeslaContainer;
import net.ndrei.teslacorelib.containers.FilteredSlot;
import net.ndrei.teslacorelib.energy.EnergySystemFactory;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGeneratorInfoProvider;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.ColoredItemHandler;
import net.ndrei.teslacorelib.inventory.EnergyStorage;
import net.ndrei.teslacorelib.inventory.SyncProviderLevel;
import net.ndrei.teslacorelib.tileentities.ElectricTileEntity;
import net.ndrei.teslacorelib.tileentities.SyncTileEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u000f\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001d\u001a\u00020\tH$J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0014J\b\u0010!\u001a\u00020\u001fH\u0014J\b\u0010\"\u001a\u00020\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u0011\u0010\u0016\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0014\u0010\u0018\u001a\u00020\u00198DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006$"}, d2={"Lnet/ndrei/teslacorelib/tileentities/ElectricGenerator;", "Lnet/ndrei/teslacorelib/tileentities/ElectricTileEntity;", "Lnet/ndrei/teslacorelib/gui/IGeneratorInfoProvider;", "typeId", "", "(I)V", "chargePadItems", "Lnet/minecraftforge/items/ItemStackHandler;", "energyFillRate", "", "getEnergyFillRate", "()J", "energyInputRate", "getEnergyInputRate", "energyOutputRate", "getEnergyOutputRate", "generatedPower", "Lnet/ndrei/teslacorelib/inventory/EnergyStorage;", "generatedPowerCapacity", "getGeneratedPowerCapacity", "generatedPowerReleaseRate", "getGeneratedPowerReleaseRate", "generatedPowerStored", "getGeneratedPowerStored", "isGeneratedPowerLostIfFull", "", "()Z", "maxEnergy", "getMaxEnergy", "consumeFuel", "fuelConsumed", "", "initializeInventories", "processImmediateInventories", "protectedUpdate", "Companion", "tesla-core-lib"})
public abstract class ElectricGenerator
extends ElectricTileEntity
implements IGeneratorInfoProvider {
    private EnergyStorage generatedPower;
    private ItemStackHandler chargePadItems;
    @NotNull
    protected static final String SYNC_GENERATED_ENERGY = "generated_energy";
    @NotNull
    protected static final String SYNC_CHARGE_PAD_ITEMS = "inv_charge_pad";
    public static final Companion Companion = new Companion(null);

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        ItemStackHandler itemStackHandler = this.chargePadItems = (ItemStackHandler)new ItemStackHandler(this, 2){
            final /* synthetic */ ElectricGenerator this$0;

            protected void onContentsChanged(int slot) {
                SyncTileEntity.partialSync$default(this.this$0, "inv_charge_pad", false, 2, null);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        if (itemStackHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chargePadItems");
        }
        super.addInventory((IItemHandler)new ColoredItemHandler(this, (IItemHandler)itemStackHandler, EnumDyeColor.BROWN, "teslacorelib:Charge Pad", -10, new BoundingRectangle(34, 34, 18, 36)){
            final /* synthetic */ ElectricGenerator this$0;

            public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
                Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
                IGenericEnergyStorage iGenericEnergyStorage = EnergySystemFactory.INSTANCE.wrapItemStack(stack);
                return iGenericEnergyStorage != null ? iGenericEnergyStorage.getCanGive() : false;
            }

            public boolean canExtractItem(int slot) {
                ItemStack itemStack = this.getStackInSlot(slot);
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.getStackInSlot(slot)");
                IGenericEnergyStorage wrapper = EnergySystemFactory.INSTANCE.wrapItemStack(itemStack);
                if (wrapper != null) {
                    return wrapper.givePower(1L, true) > 0L;
                }
                return true;
            }

            @NotNull
            public List<Slot> getSlots(@NotNull BasicTeslaContainer<?> container) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                List<Slot> slots = super.getSlots(container);
                slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 0, 35, 35));
                slots.add((Slot)new FilteredSlot(this.getItemHandlerForContainer(), 1, 35, 53));
                return slots;
            }

            @NotNull
            public List<IGuiContainerPiece> getGuiContainerPieces(@NotNull BasicTeslaGuiContainer<?> container) {
                Intrinsics.checkParameterIsNotNull(container, (String)"container");
                List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
                pieces.add(new BasicRenderedGuiPiece(25, 26, 27, 52, BasicTeslaGuiContainer.Companion.getMACHINE_BACKGROUND(), 206, 4));
                return pieces;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
        ItemStackHandler itemStackHandler2 = this.chargePadItems;
        if (itemStackHandler2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"chargePadItems");
        }
        super.addInventoryToStorage(itemStackHandler2, SYNC_CHARGE_PAD_ITEMS);
        EnergyStorage energyStorage = this.generatedPower = (EnergyStorage)new EnergyStorage(this, 0L, 0L, 0L){
            final /* synthetic */ ElectricGenerator this$0;

            public void onChanged(long old, long current) {
                super.onChanged(old, current);
                SyncTileEntity.partialSync$default(this.this$0, "generated_energy", false, 2, null);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
        }
        this.registerSyncTagPart(SYNC_GENERATED_ENERGY, (INBTSerializable<NBTTagCompound>)((INBTSerializable)energyStorage), SyncProviderLevel.GUI);
    }

    @Override
    protected long getMaxEnergy() {
        return 100000L;
    }

    @Override
    protected long getEnergyInputRate() {
        return 0L;
    }

    @Override
    protected long getEnergyOutputRate() {
        return 80L;
    }

    protected long getEnergyFillRate() {
        return 160L;
    }

    @Override
    public final long getGeneratedPowerCapacity() {
        EnergyStorage energyStorage = this.generatedPower;
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
        }
        return energyStorage.getCapacity();
    }

    @Override
    public final long getGeneratedPowerStored() {
        EnergyStorage energyStorage = this.generatedPower;
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
        }
        return energyStorage.getStored();
    }

    @Override
    public final long getGeneratedPowerReleaseRate() {
        EnergyStorage energyStorage = this.generatedPower;
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
        }
        return energyStorage.getEnergyOutputRate();
    }

    protected abstract long consumeFuel();

    protected void fuelConsumed() {
    }

    protected final boolean isGeneratedPowerLostIfFull() {
        return true;
    }

    @Override
    public void protectedUpdate() {
        long power;
        EnergyStorage energyStorage = this.generatedPower;
        if (energyStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
        }
        if (!energyStorage.isEmpty()) {
            EnergyStorage energyStorage2 = this.generatedPower;
            if (energyStorage2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
            }
            EnergyStorage energyStorage3 = this.generatedPower;
            if (energyStorage3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
            }
            power = energyStorage2.takePower(energyStorage3.getEnergyOutputRate(), !this.isGeneratedPowerLostIfFull());
            long consumed = this.getEnergyStorage().givePower(power);
            if (consumed > 0L && this.isGeneratedPowerLostIfFull()) {
                EnergyStorage energyStorage4 = this.generatedPower;
                if (energyStorage4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
                }
                energyStorage4.takePower(consumed);
            }
            EnergyStorage energyStorage5 = this.generatedPower;
            if (energyStorage5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
            }
            if (energyStorage5.isEmpty()) {
                this.fuelConsumed();
            }
        }
        EnergyStorage energyStorage6 = this.generatedPower;
        if (energyStorage6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
        }
        if (energyStorage6.isEmpty() && !this.getEnergyStorage().isFull() && !this.func_145831_w().field_72995_K) {
            EnergyStorage energyStorage7 = this.generatedPower;
            if (energyStorage7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
            }
            energyStorage7.setCapacity(0L);
            power = this.consumeFuel();
            if (power > 0L) {
                EnergyStorage energyStorage8 = this.generatedPower;
                if (energyStorage8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
                }
                energyStorage8.setCapacity(power);
                EnergyStorage energyStorage9 = this.generatedPower;
                if (energyStorage9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
                }
                energyStorage9.setEnergyOutputRate(this.getEnergyFillRate());
                EnergyStorage energyStorage10 = this.generatedPower;
                if (energyStorage10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"generatedPower");
                }
                energyStorage10.givePower(power);
            }
        }
        if (!this.getEnergyStorage().isEmpty() && !this.field_145850_b.field_72995_K) {
            List<EnumFacing> powerSides;
            Collection consumed;
            List consumers = new ArrayList();
            SidedItemHandlerConfig sidedItemHandlerConfig = this.getSideConfig();
            EnumDyeColor enumDyeColor = this.getEnergyStorage().getColor();
            if (enumDyeColor == null) {
                Intrinsics.throwNpe();
            }
            if (!(consumed = (Collection)(powerSides = sidedItemHandlerConfig.getSidesForColor(enumDyeColor))).isEmpty()) {
                BlockPos pos = this.func_174877_v();
                EnumFacing facing = this.getFacing();
                for (EnumFacing side : powerSides) {
                    IGenericEnergyStorage wrapper;
                    TileEntity entity;
                    EnumFacing oriented = this.orientFacing(side);
                    if (Intrinsics.areEqual((Object)oriented, (Object)EnumFacing.DOWN) ^ true && Intrinsics.areEqual((Object)oriented, (Object)EnumFacing.UP) ^ true && (Intrinsics.areEqual((Object)facing, (Object)EnumFacing.EAST) || Intrinsics.areEqual((Object)facing, (Object)EnumFacing.WEST))) {
                        EnumFacing enumFacing = oriented.func_176734_d();
                        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"oriented.opposite");
                        oriented = enumFacing;
                    }
                    if (this.func_145831_w().func_175625_s(pos.func_177972_a(oriented)) == null) {
                        continue;
                    }
                    TileEntity tileEntity = entity;
                    Intrinsics.checkExpressionValueIsNotNull((Object)tileEntity, (String)"entity");
                    EnumFacing enumFacing = oriented.func_176734_d();
                    Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"oriented.opposite");
                    if (EnergySystemFactory.INSTANCE.wrapTileEntity(tileEntity, enumFacing) == null) {
                        continue;
                    }
                    consumers.add(wrapper);
                }
            }
            if (consumers.size() > 0) {
                long total = this.getEnergyStorage().getEnergyOutputRate();
                total = this.getEnergyStorage().takePower(total, true);
                long totalConsumed = 0L;
                int consumerCount = consumers.size();
                for (IGenericEnergyStorage consumer : consumers) {
                    long consumed2;
                    long perConsumer = total / (long)consumerCount;
                    --consumerCount;
                    if (perConsumer <= 0L || (consumed2 = consumer.givePower(perConsumer, false)) <= 0L) continue;
                    totalConsumed += consumed2;
                }
                if (totalConsumed > 0L) {
                    this.getEnergyStorage().takePower(totalConsumed);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processImmediateInventories() {
        super.processImmediateInventories();
        int n = 0;
        int n2 = 2;
        while (n < n2) {
            void index;
            ItemStack stack;
            ItemStackHandler itemStackHandler = this.chargePadItems;
            if (itemStackHandler == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"chargePadItems");
            }
            ItemStack itemStack = stack = itemStackHandler.getStackInSlot((int)index);
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            if (!itemStack.func_190926_b()) {
                long consumed;
                long available = this.getEnergyStorage().takePower(this.getEnergyStorage().getEnergyOutputRate(), true);
                if (available == 0L) break;
                IGenericEnergyStorage wrapper = EnergySystemFactory.INSTANCE.wrapItemStack(stack);
                if (wrapper != null && (consumed = wrapper.givePower(available, false)) > 0L) {
                    this.getEnergyStorage().takePower(consumed, false);
                }
            }
            ++index;
        }
    }

    protected ElectricGenerator(int typeId) {
        super(typeId);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/ndrei/teslacorelib/tileentities/ElectricGenerator$Companion;", "", "()V", "SYNC_CHARGE_PAD_ITEMS", "", "SYNC_GENERATED_ENERGY", "tesla-core-lib"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

