/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.definitions.zenclasses;

import org.objectweb.asm.ClassWriter;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.EnvironmentScript;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.parser.expression.ParsedExpression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.ZenNativeMember;
import stanhebben.zenscript.util.MethodOutput;

public class ParsedZenClassField {
    public final boolean isStatic;
    public final ParsedExpression initializer;
    public final String name;
    private final String ownerName;
    public ZenType type;

    public ParsedZenClassField(boolean isStatic, ZenType type, ParsedExpression initializer, String name, String ownerName) {
        this.isStatic = isStatic;
        this.type = type;
        this.initializer = initializer;
        this.name = name;
        this.ownerName = ownerName;
    }

    public static ParsedZenClassField parse(ZenTokener parser, EnvironmentScript classEnvironment, boolean isStatic, String ownerName) {
        String name = parser.required(1, "Identifier expected").getValue();
        ZenType type = ZenType.ANY;
        if (parser.optional(120) != null) {
            type = ZenType.read(parser, classEnvironment);
        }
        ParsedExpression initializer = null;
        if (parser.optional(39) != null) {
            initializer = ParsedExpression.read(parser, classEnvironment);
        }
        parser.required(33, "; expected");
        return new ParsedZenClassField(isStatic, type, initializer, name, ownerName);
    }

    void addMethodsToMember(ZenNativeMember zenNativeMember) {
        zenNativeMember.setGetter(new ZenClassFieldMethod(false));
        zenNativeMember.setSetter(new ZenClassFieldMethod(true));
    }

    public boolean hasInitializer() {
        return this.initializer != null;
    }

    public void visit(ClassWriter newClass) {
        newClass.visitField(!this.isStatic ? 1 : 9, this.name, this.type.toASMType().getDescriptor(), null, null).visitEnd();
    }

    public void writeAll(IEnvironmentMethod clinitEnvironment, ClassWriter newClass, MethodOutput clinit, String className) {
        Expression expression;
        Expression expression2 = expression = this.hasInitializer() ? this.initializer.compile(clinitEnvironment, this.type).eval(clinitEnvironment) : null;
        if (this.type == ZenType.ANY && expression != null) {
            this.type = expression.getType();
        }
        this.visit(newClass);
        if (expression != null) {
            expression.compile(true, clinitEnvironment);
            clinit.putStaticField(className, this.name, this.type.toASMType().getDescriptor());
        }
    }

    private final class ZenClassFieldMethod
    implements IJavaMethod {
        private final boolean isSetter;

        private ZenClassFieldMethod(boolean isSetter) {
            this.isSetter = isSetter;
        }

        @Override
        public boolean isStatic() {
            return ParsedZenClassField.this.isStatic;
        }

        @Override
        public boolean accepts(int numArguments) {
            return numArguments == (this.isSetter ? 1 : 0);
        }

        @Override
        public boolean accepts(IEnvironmentGlobal environment, Expression ... arguments) {
            return this.accepts(arguments.length) && (!this.isSetter || arguments[0].getType().canCastImplicit(ParsedZenClassField.this.type, environment));
        }

        @Override
        public int getPriority(IEnvironmentGlobal environment, Expression ... arguments) {
            return this.accepts(environment, arguments) ? 1 : -1;
        }

        @Override
        public void invokeVirtual(MethodOutput output) {
            if (this.isStatic()) {
                if (this.isSetter) {
                    output.putStaticField(ParsedZenClassField.this.ownerName, ParsedZenClassField.this.name, ParsedZenClassField.this.type.getSignature());
                } else {
                    output.getStaticField(ParsedZenClassField.this.ownerName, ParsedZenClassField.this.name, ParsedZenClassField.this.type.getSignature());
                }
            } else if (this.isSetter) {
                output.putField(ParsedZenClassField.this.ownerName, ParsedZenClassField.this.name, ParsedZenClassField.this.type.getSignature());
            } else {
                output.getField(ParsedZenClassField.this.ownerName, ParsedZenClassField.this.name, ParsedZenClassField.this.type.getSignature());
            }
        }

        @Override
        public void invokeStatic(MethodOutput output) {
            if (!this.isStatic()) {
                throw new IllegalArgumentException("Cannot invoke nonstatic method from a static context");
            }
            output.getStaticField(ParsedZenClassField.this.ownerName, ParsedZenClassField.this.name, ParsedZenClassField.this.type.getSignature());
        }

        @Override
        public ZenType[] getParameterTypes() {
            ZenType[] zenTypeArray;
            if (this.isSetter) {
                ZenType[] zenTypeArray2 = new ZenType[1];
                zenTypeArray = zenTypeArray2;
                zenTypeArray2[0] = ParsedZenClassField.this.type;
            } else {
                zenTypeArray = new ZenType[]{};
            }
            return zenTypeArray;
        }

        @Override
        public ZenType getReturnType() {
            return this.isSetter ? ZenType.VOID : ParsedZenClassField.this.type;
        }

        @Override
        public boolean isVarargs() {
            return false;
        }

        @Override
        public String getErrorDescription() {
            return "INTERNAL METHOD";
        }
    }
}

