/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.compiler;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.compiler.IEnvironmentClass;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.util.ZenPosition;

public class EnvironmentClass
implements IEnvironmentClass {
    private final ClassVisitor output;
    private final IEnvironmentGlobal global;
    private final Map<String, IZenSymbol> local;

    public EnvironmentClass(ClassVisitor output, IEnvironmentGlobal global) {
        this.output = output;
        this.global = global;
        this.local = new HashMap<String, IZenSymbol>();
    }

    @Override
    public ClassVisitor getClassOutput() {
        return this.output;
    }

    @Override
    public ZenType getType(Type type) {
        return this.global.getType(type);
    }

    @Override
    public IZenCompileEnvironment getEnvironment() {
        return this.global.getEnvironment();
    }

    @Override
    public TypeExpansion getExpansion(String name) {
        return this.global.getExpansion(name);
    }

    @Override
    public String makeClassName() {
        return this.global.makeClassName();
    }

    @Override
    public String makeClassNameWithMiddleName(String middleName) {
        return this.global.makeClassNameWithMiddleName(middleName);
    }

    @Override
    public boolean containsClass(String name) {
        return this.global.containsClass(name);
    }

    @Override
    public void putClass(String name, byte[] data) {
        this.global.putClass(name, data);
    }

    @Override
    public IPartialExpression getValue(String name, ZenPosition position) {
        if (this.local.containsKey(name)) {
            return this.local.get(name).instance(position);
        }
        return this.global.getValue(name, position);
    }

    @Override
    public void putValue(String name, IZenSymbol value, ZenPosition position) {
        if (this.local.containsKey(name)) {
            this.error(position, "Value already defined in this scope: " + name);
        } else {
            this.local.put(name, value);
        }
    }

    @Override
    public void error(ZenPosition position, String message) {
        this.global.error(position, message);
    }

    @Override
    public void warning(ZenPosition position, String message) {
        this.global.warning(position, message);
    }

    @Override
    public void info(ZenPosition position, String message) {
        this.global.info(position, message);
    }

    @Override
    public Set<String> getClassNames() {
        return this.global.getClassNames();
    }

    @Override
    public byte[] getClass(String name) {
        return this.global.getClass(name);
    }

    @Override
    public void error(String message) {
        this.global.error(message);
    }

    @Override
    public void error(String message, Throwable e) {
        this.global.error(message, e);
    }

    @Override
    public void warning(String message) {
        this.global.warning(message);
    }

    @Override
    public void info(String message) {
        this.global.info(message);
    }
}

