/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.enums.EnumSnapshotType;
import buildcraft.api.filler.IFilledTemplate;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.lib.misc.VecUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class Template
extends Snapshot {
    public BitSet data;

    @Override
    public Template copy() {
        Template template = new Template();
        template.size = this.size;
        template.facing = this.facing;
        template.offset = this.offset;
        template.data = (BitSet)this.data.clone();
        template.computeKey();
        return template;
    }

    public FilledTemplate getFilledTemplate() {
        return new FilledTemplate();
    }

    public void invert() {
        this.data.flip(0, this.getDataSize());
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74773_a("data", this.data.toByteArray());
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        super.deserializeNBT(nbt);
        this.data = BitSet.valueOf(nbt.func_74770_j("data"));
        if (this.data.length() > this.getDataSize()) {
            throw new InvalidInputDataException("Serialized data has length of " + this.data.length() + ", but we expected at most " + this.getDataSize() + " (" + this.size.toString() + ")");
        }
    }

    @Override
    public EnumSnapshotType getType() {
        return EnumSnapshotType.TEMPLATE;
    }

    public class FilledTemplate
    implements IFilledTemplate {
        private final BlockPos max;

        public FilledTemplate() {
            this.max = Template.this.size.func_177973_b((Vec3i)VecUtil.POS_ONE);
        }

        public Template getTemplate() {
            return Template.this;
        }

        private void checkPos(int x, int y, int z) {
            if (x < 0 || y < 0 || z < 0 || x >= Template.this.size.func_177958_n() || y >= Template.this.size.func_177956_o() || z >= Template.this.size.func_177952_p()) {
                throw new IllegalArgumentException("Size: " + Template.this.size + ", pos: " + new BlockPos(x, y, z));
            }
        }

        public BlockPos getSize() {
            return Template.this.size;
        }

        public BlockPos getMax() {
            return this.max;
        }

        public void set(int x, int y, int z, boolean value) {
            this.checkPos(x, y, z);
            Template.this.data.set(Template.this.posToIndex(x, y, z), value);
        }

        public boolean get(int x, int y, int z) {
            this.checkPos(x, y, z);
            return Template.this.data.get(Template.this.posToIndex(x, y, z));
        }

        public void setLineX(int fromX, int toX, int y, int z, boolean value) {
            this.checkPos(fromX, y, z);
            this.checkPos(toX, y, z);
            Template.this.data.set(Template.this.posToIndex(fromX, y, z), Template.this.posToIndex(toX, y, z) + 1, value);
        }

        public void setLineY(int x, int fromY, int toY, int z, boolean value) {
            this.checkPos(x, fromY, z);
            this.checkPos(x, toY, z);
            for (int y = fromY; y <= toY; ++y) {
                this.set(x, y, z, value);
            }
        }

        public void setLineZ(int x, int y, int fromZ, int toZ, boolean value) {
            this.checkPos(x, y, fromZ);
            this.checkPos(x, y, toZ);
            for (int z = fromZ; z <= toZ; ++z) {
                this.set(x, y, z, value);
            }
        }

        public void setAreaYZ(int x, int fromY, int toY, int fromZ, int toZ, boolean value) {
            this.checkPos(x, fromY, fromZ);
            this.checkPos(x, toY, toZ);
            for (int z = fromZ; z <= toZ; ++z) {
                this.setLineY(x, fromY, toY, z, value);
            }
        }

        public void setAreaXZ(int fromX, int toX, int y, int fromZ, int toZ, boolean value) {
            this.checkPos(fromX, y, fromZ);
            this.checkPos(toX, y, toZ);
            for (int z = fromZ; z <= toZ; ++z) {
                this.setLineX(fromX, toX, y, z, true);
            }
        }

        public void setAreaXY(int fromX, int toX, int fromY, int toY, int z, boolean value) {
            this.checkPos(fromX, fromY, z);
            this.checkPos(toX, toY, z);
            for (int y = fromY; y <= toY; ++y) {
                this.setLineX(fromX, toX, y, z, true);
            }
        }

        public void setPlaneYZ(int x, boolean value) {
            this.checkPos(x, 0, 0);
            this.setAreaYZ(x, 0, this.max.func_177956_o(), 0, this.max.func_177952_p(), value);
        }

        public void setPlaneXZ(int y, boolean value) {
            this.checkPos(0, y, 0);
            this.setAreaXZ(0, this.max.func_177958_n(), y, 0, this.max.func_177952_p(), value);
        }

        public void setPlaneXY(int z, boolean value) {
            this.checkPos(0, 0, z);
            Template.this.data.set(Template.this.posToIndex(0, 0, z), Template.this.posToIndex(this.max.func_177958_n(), this.max.func_177956_o(), z) + 1, value);
        }

        public void setAll(boolean value) {
            Template.this.data.set(0, Template.this.getDataSize(), value);
        }

        public String toString() {
            ArrayList<String> zParts = new ArrayList<String>();
            for (int z = 0; z < this.getSize().func_177952_p(); ++z) {
                ArrayList<String> yParts = new ArrayList<String>();
                for (int y = 0; y < this.getSize().func_177956_o(); ++y) {
                    ArrayList<String> xParts = new ArrayList<String>();
                    for (int x = 0; x < this.getSize().func_177958_n(); ++x) {
                        xParts.add(this.get(x, y, z) ? "#" : " ");
                    }
                    yParts.add(String.join((CharSequence)"", xParts));
                }
                zParts.add(String.join((CharSequence)"\n", yParts));
            }
            return String.join((CharSequence)("\n" + String.join((CharSequence)"", Collections.nCopies(this.getSize().func_177958_n(), "-")) + "\n"), zParts);
        }
    }

    public class BuildingInfo
    extends Snapshot.BuildingInfo {
        public BuildingInfo(BlockPos basePos, Rotation rotation) {
            super(basePos, rotation);
        }

        @Override
        public Template getSnapshot() {
            return Template.this;
        }
    }
}

