/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.builders.snapshot.FluidStackRef;
import buildcraft.builders.snapshot.ItemStackRef;
import buildcraft.builders.snapshot.RequiredExtractor;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class RequiredExtractorConstant
extends RequiredExtractor {
    @SerializedName(value="items")
    private List<ItemStackRef> itemRefs = Collections.emptyList();
    @SerializedName(value="fluids")
    private List<FluidStackRef> fluidRefs = Collections.emptyList();

    @Override
    @Nonnull
    public List<ItemStack> extractItemsFromBlock(@Nonnull IBlockState blockState, @Nullable NBTTagCompound tileNbt) {
        return Collections.unmodifiableList(this.itemRefs.stream().map(ref -> ref.get((NBTBase)tileNbt)).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public List<FluidStack> extractFluidsFromBlock(@Nonnull IBlockState blockState, @Nullable NBTTagCompound tileNbt) {
        return Collections.unmodifiableList(this.fluidRefs.stream().map(ref -> ref.get((NBTBase)tileNbt)).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public List<ItemStack> extractItemsFromEntity(@Nonnull NBTTagCompound entityNbt) {
        return Collections.unmodifiableList(this.itemRefs.stream().map(ref -> ref.get((NBTBase)entityNbt)).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public List<FluidStack> extractFluidsFromEntity(@Nonnull NBTTagCompound entityNbt) {
        return Collections.unmodifiableList(this.fluidRefs.stream().map(ref -> ref.get((NBTBase)entityNbt)).collect(Collectors.toList()));
    }
}

