/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientSerializer;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponentCategoryType;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.commoncapabilities.api.ingredient.capability.AttachCapabilitiesEventIngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageHandler;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;

@Mod.EventBusSubscriber(modid="commoncapabilities")
public final class IngredientComponent<T, M>
implements IForgeRegistryEntry<IngredientComponent<?, ?>>,
Comparable<IngredientComponent<?, ?>> {
    public static IForgeRegistry<IngredientComponent<?, ?>> REGISTRY;
    @GameRegistry.ObjectHolder(value="minecraft:itemstack")
    public static final IngredientComponent<ItemStack, Integer> ITEMSTACK;
    @GameRegistry.ObjectHolder(value="minecraft:fluidstack")
    public static final IngredientComponent<FluidStack, Integer> FLUIDSTACK;
    @GameRegistry.ObjectHolder(value="minecraft:energy")
    public static final IngredientComponent<Integer, Boolean> ENERGY;
    @CapabilityInject(value=IIngredientComponentStorageHandler.class)
    private static Capability<IIngredientComponentStorageHandler> CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLER;
    private static Map<Capability<?>, IngredientComponent<?, ?>> STORAGE_WRAPPER_CAPABILITIES_COMPONENTS;
    private final IIngredientMatcher<T, M> matcher;
    private final IIngredientSerializer<T, M> serializer;
    private final List<IngredientComponentCategoryType<T, M, ?>> categoryTypes;
    private final List<Capability<?>> storageWrapperCapabilities;
    private final Map<Capability<?>, IIngredientComponentStorageWrapperHandler<T, M, ?>> storageWrapperHandler;
    private final IngredientComponentCategoryType<T, M, ?> primaryQuantifier;
    private final CapabilityDispatcher capabilityDispatcher;
    private ResourceLocation name;
    private String translationKey;

    @SubscribeEvent
    public static void onRegistriesCreate(RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("commoncapabilities", "registry:ingredientcomponents")).setType(IngredientComponent.class).create();
    }

    public IngredientComponent(ResourceLocation name, IIngredientMatcher<T, M> matcher, IIngredientSerializer<T, M> serializer, List<IngredientComponentCategoryType<T, M, ?>> categoryTypes) {
        this.setRegistryName(name);
        this.matcher = matcher;
        this.serializer = serializer;
        this.categoryTypes = Lists.newArrayList(categoryTypes);
        this.storageWrapperCapabilities = Lists.newArrayList();
        this.storageWrapperHandler = Maps.newIdentityHashMap();
        this.capabilityDispatcher = this.gatherCapabilities();
        M matchCondition = this.matcher.getAnyMatchCondition();
        IngredientComponentCategoryType<T, M, ?> primaryQuantifier = null;
        for (IngredientComponentCategoryType<T, M, ?> categoryType : this.categoryTypes) {
            matchCondition = this.matcher.withCondition(matchCondition, categoryType.getMatchCondition());
            if (!categoryType.isPrimaryQuantifier()) continue;
            if (primaryQuantifier != null) {
                throw new IllegalArgumentException("Found more than one primary quantifier in category types.");
            }
            primaryQuantifier = categoryType;
        }
        this.primaryQuantifier = primaryQuantifier;
        if (!Objects.equals(matchCondition, this.getMatcher().getExactMatchCondition())) {
            throw new IllegalArgumentException("The given category types when combined do not conform to the exact match conditions of the matcher.");
        }
    }

    public IngredientComponent(String name, IIngredientMatcher<T, M> matcher, IIngredientSerializer<T, M> serializer, List<IngredientComponentCategoryType<T, M, ?>> categoryTypes) {
        this(new ResourceLocation(name), matcher, serializer, categoryTypes);
        this.gatherCapabilities();
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String toString() {
        return "[Recipe Component " + this.name + " " + this.hashCode() + "]";
    }

    public IngredientComponent<T, M> setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<IngredientComponent<?, ?>> getRegistryType() {
        return IngredientComponent.class;
    }

    protected CapabilityDispatcher gatherCapabilities() {
        AttachCapabilitiesEventIngredientComponent event = new AttachCapabilitiesEventIngredientComponent(this);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities()) : null;
    }

    public boolean hasCapability(Capability<?> capability) {
        return this.capabilityDispatcher != null && this.capabilityDispatcher.hasCapability(capability, null);
    }

    public <TC> TC getCapability(Capability<TC> capability) {
        return (TC)(this.capabilityDispatcher == null ? null : this.capabilityDispatcher.getCapability(capability, null));
    }

    public IngredientComponent<T, M> setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
        return this;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public IIngredientMatcher<T, M> getMatcher() {
        return this.matcher;
    }

    public IIngredientSerializer<T, M> getSerializer() {
        return this.serializer;
    }

    public List<IngredientComponentCategoryType<T, M, ?>> getCategoryTypes() {
        return this.categoryTypes;
    }

    public IngredientInstanceWrapper<T, M> wrap(T instance) {
        return new IngredientInstanceWrapper(this, instance);
    }

    @Nullable
    public IngredientComponentCategoryType<T, M, ?> getPrimaryQuantifier() {
        return this.primaryQuantifier;
    }

    public <S> void setStorageWrapperHandler(Capability<S> capability, IIngredientComponentStorageWrapperHandler<T, M, ? super S> storageWrapperHandler) {
        if (capability != null && this.storageWrapperHandler.put(capability, storageWrapperHandler) == null) {
            this.storageWrapperCapabilities.add(capability);
            IngredientComponent previousValue = STORAGE_WRAPPER_CAPABILITIES_COMPONENTS.put(capability, this);
            if (previousValue != null) {
                throw new IllegalStateException(String.format("Tried registering a storage capability (%s) for %s that was already registered to %s", capability.getName(), this, previousValue));
            }
        }
    }

    @Nullable
    public <S> IIngredientComponentStorageWrapperHandler<T, M, S> getStorageWrapperHandler(Capability<S> capability) {
        return this.storageWrapperHandler.get(capability);
    }

    public Collection<Capability<?>> getStorageWrapperHandlerCapabilities() {
        return this.storageWrapperCapabilities;
    }

    @Nullable
    public static IngredientComponent<?, ?> getIngredientComponentForStorageCapability(Capability<?> capability) {
        return STORAGE_WRAPPER_CAPABILITIES_COMPONENTS.get(capability);
    }

    @Nullable
    public IIngredientComponentStorage<T, M> getStorage(ICapabilityProvider capabilityProvider, @Nullable EnumFacing facing) {
        IIngredientComponentStorageHandler storageHandler;
        IIngredientComponentStorage storage;
        if (capabilityProvider.hasCapability(CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLER, facing) && (storage = (storageHandler = (IIngredientComponentStorageHandler)capabilityProvider.getCapability(CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLER, facing)).getStorage(this)) != null) {
            return storage;
        }
        for (Capability<?> capability : this.getStorageWrapperHandlerCapabilities()) {
            IIngredientComponentStorageWrapperHandler<T, M, ?> wrapperHandler = this.getStorageWrapperHandler(capability);
            IIngredientComponentStorage<T, M> storage2 = wrapperHandler.getComponentStorage(capabilityProvider, facing);
            if (storage2 == null) continue;
            return storage2;
        }
        return null;
    }

    @Override
    public int compareTo(IngredientComponent<?, ?> that) {
        return this.getName().compareTo(that.getName());
    }

    static {
        ITEMSTACK = null;
        FLUIDSTACK = null;
        ENERGY = null;
        CAPABILITY_INGREDIENT_COMPONENT_STORAGE_HANDLER = null;
        STORAGE_WRAPPER_CAPABILITIES_COMPONENTS = Maps.newIdentityHashMap();
    }
}

