/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config.adapter;

import com.google.common.primitives.Booleans;
import com.google.common.primitives.Bytes;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.CompatForgeRegistryEntry;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config.adapter.PathTypeAdapter;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config.adapter.ResourceLocationTypeAdapter;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.config.adapter.TRLTypeAdapter;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.common.config.Property;

public final class TRLTypeAdapters {
    private static final Map<Class<?>, TRLTypeAdapter> ADAPTERS = new HashMap();

    public static TRLTypeAdapter get(Class<?> clazz) {
        TRLTypeAdapter adapter = ADAPTERS.get(clazz);
        if (adapter != null || CompatForgeRegistryEntry.CLASS == null) {
            return adapter;
        }
        if (CompatForgeRegistryEntry.CLASS.isAssignableFrom(clazz)) {
            TRLTypeAdapters.register(clazz);
        } else {
            Class<?> componentType = clazz.getComponentType();
            if (CompatForgeRegistryEntry.CLASS.isAssignableFrom(componentType)) {
                TRLTypeAdapters.register(componentType);
            } else {
                return null;
            }
        }
        return ADAPTERS.get(clazz);
    }

    public static void register(Class<?> clazz, TRLTypeAdapter adapter) {
        ADAPTERS.put(clazz, adapter);
    }

    public static void register(Class<?> clazz1, Class<?> clazz2, TRLTypeAdapter adapter) {
        TRLTypeAdapters.register(clazz1, adapter);
        TRLTypeAdapters.register(clazz2, adapter);
    }

    public static void register(Class<?> registryEntryClass) {
        TRLTypeAdapters.register(registryEntryClass, new ResourceLocationTypeAdapter(registryEntryClass, false));
        TRLTypeAdapters.register(Array.newInstance(registryEntryClass, 0).getClass(), new ResourceLocationTypeAdapter(registryEntryClass, true));
    }

    static {
        TRLTypeAdapters.register(Boolean.TYPE, Boolean.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return property.getBoolean();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValue(((Boolean)value).booleanValue());
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValue(((Boolean)value).booleanValue());
            }

            @Override
            public Property.Type getType() {
                return Property.Type.BOOLEAN;
            }
        });
        TRLTypeAdapters.register(boolean[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return property.getBooleanList();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues((boolean[])value);
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues((boolean[])value);
            }

            @Override
            public Property.Type getType() {
                return Property.Type.BOOLEAN;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Boolean[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Booleans.asList((boolean[])property.getBooleanList()).toArray(new Boolean[0]);
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Booleans.toArray(Arrays.asList((Boolean[])value)));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Booleans.toArray(Arrays.asList((Boolean[])value)));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.BOOLEAN;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Byte.TYPE, Byte.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return (byte)property.getInt();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValue((int)((Byte)value).byteValue());
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValue((int)((Byte)value).byteValue());
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }
        });
        TRLTypeAdapters.register(byte[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Bytes.toArray((Collection)Ints.asList((int[])property.getIntList()));
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Ints.toArray((Collection)Bytes.asList((byte[])((byte[])value))));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Ints.toArray((Collection)Bytes.asList((byte[])((byte[])value))));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Byte[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Bytes.asList((byte[])Bytes.toArray((Collection)Ints.asList((int[])property.getIntList()))).toArray(new Byte[0]);
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Ints.toArray(Arrays.asList((Byte[])value)));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Ints.toArray(Arrays.asList((Byte[])value)));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Character.TYPE, Character.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                String string = property.getString();
                return Character.valueOf(string.isEmpty() ? (char)' ' : string.charAt(0));
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValue(Character.toString(((Character)value).charValue()));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValue(Character.toString(((Character)value).charValue()));
            }
        });
        TRLTypeAdapters.register(char[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Chars.toArray((Collection)Arrays.stream(property.getStringList()).map(string -> Character.valueOf(string.isEmpty() ? (char)' ' : string.charAt(0))).collect(Collectors.toList()));
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues((String[])Chars.asList((char[])((char[])value)).stream().map(character -> Character.toString(character.charValue())).toArray(String[]::new));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues((String[])Chars.asList((char[])((char[])value)).stream().map(character -> Character.toString(character.charValue())).toArray(String[]::new));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.STRING;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Character[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Arrays.stream(property.getStringList()).map(string -> Character.valueOf(string.isEmpty() ? (char)' ' : string.charAt(0))).toArray(Character[]::new);
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues((String[])Arrays.stream((Character[])value).map(character -> Character.toString(character.charValue())).toArray(String[]::new));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues((String[])Arrays.stream((Character[])value).map(character -> Character.toString(character.charValue())).toArray(String[]::new));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.STRING;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Double.TYPE, Double.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return property.getDouble();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValue(((Double)value).doubleValue());
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValue(((Double)value).doubleValue());
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }
        });
        TRLTypeAdapters.register(double[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return property.getDoubleList();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues((double[])value);
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues((double[])value);
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Double[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Doubles.asList((double[])property.getDoubleList()).toArray(new Double[0]);
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Doubles.toArray(Arrays.asList((Double[])value)));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Doubles.toArray(Arrays.asList((Double[])value)));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Float.TYPE, Float.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Float.valueOf((float)property.getDouble());
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValue((double)((Float)value).floatValue());
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValue((double)((Float)value).floatValue());
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }
        });
        TRLTypeAdapters.register(float[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Floats.toArray((Collection)Doubles.asList((double[])property.getDoubleList()));
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Doubles.toArray((Collection)Floats.asList((float[])((float[])value))));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Doubles.toArray((Collection)Floats.asList((float[])((float[])value))));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Float[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Floats.asList((float[])Floats.toArray((Collection)Doubles.asList((double[])property.getDoubleList()))).toArray(new Float[0]);
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Doubles.toArray(Arrays.asList((Float[])value)));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Doubles.toArray(Arrays.asList((Float[])value)));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Integer.TYPE, Integer.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return property.getInt();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValue(((Integer)value).intValue());
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValue(((Integer)value).intValue());
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }
        });
        TRLTypeAdapters.register(int[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return property.getIntList();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues((int[])value);
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues((int[])value);
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Integer[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Ints.asList((int[])property.getIntList()).toArray(new Integer[0]);
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Ints.toArray(Arrays.asList((Integer[])value)));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Ints.toArray(Arrays.asList((Integer[])value)));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Long.TYPE, Long.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return (long)property.getDouble();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValue((double)((Long)value).longValue());
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValue((double)((Long)value).longValue());
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }
        });
        TRLTypeAdapters.register(long[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Longs.toArray((Collection)Doubles.asList((double[])property.getDoubleList()));
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Doubles.toArray((Collection)Longs.asList((long[])((long[])value))));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Doubles.toArray((Collection)Longs.asList((long[])((long[])value))));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Long[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Longs.asList((long[])Longs.toArray((Collection)Doubles.asList((double[])property.getDoubleList()))).toArray(new Long[0]);
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Doubles.toArray(Arrays.asList((Long[])value)));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Doubles.toArray(Arrays.asList((Long[])value)));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.DOUBLE;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Short.TYPE, Short.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return (short)property.getInt();
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValue((int)((Short)value).shortValue());
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValue((int)((Short)value).shortValue());
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }
        });
        TRLTypeAdapters.register(short[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Shorts.toArray((Collection)Ints.asList((int[])property.getIntList()));
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Ints.toArray((Collection)Shorts.asList((short[])((short[])value))));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Ints.toArray((Collection)Shorts.asList((short[])((short[])value))));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Short[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return Shorts.asList((short[])Shorts.toArray((Collection)Ints.asList((int[])property.getIntList()))).toArray(new Short[0]);
            }

            @Override
            public void setDefaultValue(Property property, Object value) {
                property.setDefaultValues(Ints.toArray(Arrays.asList((Short[])value)));
            }

            @Override
            public void setValue(Property property, Object value) {
                property.setValues(Ints.toArray(Arrays.asList((Short[])value)));
            }

            @Override
            public Property.Type getType() {
                return Property.Type.INTEGER;
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(String.class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return property.getString();
            }

            @Override
            public String asString(Object value) {
                return value instanceof Enum ? ((Enum)value).name() : String.valueOf(value);
            }
        });
        TRLTypeAdapters.register(String[].class, new TRLTypeAdapter(){

            @Override
            public Object getValue(Property property) {
                return property.getStringList();
            }

            @Override
            public String asString(Object value) {
                return value instanceof Enum ? ((Enum)value).name() : String.valueOf(value);
            }

            @Override
            public boolean isArray() {
                return true;
            }
        });
        TRLTypeAdapters.register(Path.class, new PathTypeAdapter(false));
        TRLTypeAdapters.register(Path[].class, new PathTypeAdapter(true));
    }
}

