/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch.client;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.client.WindowIconHandler;
import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public final class MinecraftPatch
extends Patch {
    public static final int KEY_UNUSED = 84;

    @Override
    public boolean apply(ClassNode node) {
        if (RPConfig.Client.isNarratorKeybindEnabled()) {
            this.patchDispatchKeypresses(MinecraftPatch.findInstructions(node, "dispatchKeypresses", "func_152348_aa"));
        }
        if (!RandomPatches.DEFAULT_WINDOW_TITLE.equals(RPConfig.Window.title)) {
            MinecraftPatch.patchCreateDisplay(MinecraftPatch.findInstructions(node, "createDisplay", "func_175609_am"));
        }
        if (!RPConfig.Window.icon16String.isEmpty()) {
            MinecraftPatch.patchSetWindowIcon(MinecraftPatch.findInstructions(node, "setWindowIcon", "func_175594_ao"));
        }
        return true;
    }

    @Override
    public boolean computeFrames() {
        return !RandomPatches.REPLAY_MOD_INSTALLED;
    }

    private void patchDispatchKeypresses(InsnList instructions) {
        IntInsnNode isB = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 16) continue;
            isB = (IntInsnNode)instruction;
            if (isB.operand == 48) break;
            isB = null;
        }
        instructions.insertBefore(isB.getPrevious(), (AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "handleKeypress", "()V", false));
        isB.operand = 84;
    }

    private static void patchCreateDisplay(InsnList instructions) {
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 184) continue;
            MethodInsnNode setTitle = (MethodInsnNode)instruction;
            if (!"setTitle".equals(setTitle.name)) continue;
            ((LdcInsnNode)setTitle.getPrevious()).cst = RPConfig.Window.title;
            return;
        }
    }

    private static void patchSetWindowIcon(InsnList instructions) {
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, MinecraftPatch.getName(WindowIconHandler.class), "setWindowIcon", "()V", false));
        newInstructions.add((AbstractInsnNode)new InsnNode(177));
        instructions.insertBefore(instructions.getFirst(), newInstructions);
    }
}

