/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch;

import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import com.therandomlabs.randompatches.repackage.com.therandomlabs.randomlib.TRLUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class TileEntityPistonPatch
extends Patch {
    @Override
    public boolean apply(ClassNode node) {
        InsnList update = TileEntityPistonPatch.findInstructions(node, "update", "func_73660_a");
        if (RPConfig.Misc.pistonGhostBlocksFix && TRLUtils.MC_VERSION_NUMBER > 8) {
            this.patchUpdateGhostBlockFix(update);
        }
        if (RPConfig.Misc.isObserverSignalFixEnabled()) {
            this.patchUpdateSignalFix(update);
            this.patchClearPistonTileEntity(TileEntityPistonPatch.findInstructions(node, "clearPistonTileEntity", "func_145866_f"));
        }
        return true;
    }

    @Override
    public boolean computeFrames() {
        return RPConfig.Misc.isObserverSignalFixEnabled();
    }

    private void patchUpdateGhostBlockFix(InsnList instructions) {
        AbstractInsnNode jumpIfNotPistonExtension = null;
        for (int i = 0; i < instructions.size() && (jumpIfNotPistonExtension = instructions.get(i)).getOpcode() != 166; ++i) {
            jumpIfNotPistonExtension = null;
        }
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", TileEntityPistonPatch.getName("world", "field_145850_b"), "Lnet/minecraft/world/World;"));
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/tileentity/TileEntity", TileEntityPistonPatch.getName("pos", "field_174879_c"), "Lnet/minecraft/util/math/BlockPos;"));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "updatePistonExtension", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V", false));
        instructions.insert(jumpIfNotPistonExtension, newInstructions);
    }

    private void patchUpdateSignalFix(InsnList instructions) {
        AbstractInsnNode popAfterSetBlockState = null;
        for (int i = 0; i < instructions.size() && ((popAfterSetBlockState = instructions.get(i)).getOpcode() != 87 || popAfterSetBlockState.getPrevious().getOpcode() != 182); ++i) {
            popAfterSetBlockState = null;
        }
        InsnList newInstructions = new InsnList();
        newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, this.hookClass, "onPistonMoveBlock", "(Lnet/minecraft/tileentity/TileEntityPiston;)V", false));
        instructions.insert(popAfterSetBlockState, newInstructions);
    }

    private void patchClearPistonTileEntity(InsnList instructions) {
        this.patchUpdateSignalFix(instructions);
    }
}

