/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.jaff.network;

import com.tmtravlr.jaff.JAFFEventHandlerClient;
import com.tmtravlr.jaff.JAFFMod;
import com.tmtravlr.jaff.entities.EntityFishPufferfish;
import com.tmtravlr.jaff.entities.EntityIronFishHook;
import com.tmtravlr.jaff.items.ItemHookedFishingRod;
import com.tmtravlr.jaff.network.SToCMessage;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketHandlerClient
implements IMessageHandler<SToCMessage, IMessage> {
    public static final int PUFFERFISH_SCARED = 1;
    public static final int SPAWN_HOOK = 2;
    public static final int HOOK_FISH = 3;
    public static final int BREAK_FISHING_ROD = 4;
    public static final int SET_INVENTORY_ITEM = 5;

    public IMessage onMessage(SToCMessage packet, MessageContext context) {
        PacketBuffer buff = new PacketBuffer(Unpooled.wrappedBuffer((byte[])packet.getData()));
        EntityPlayer player = JAFFMod.proxy.getPlayer();
        World world = null;
        if (player != null) {
            world = player.field_70170_p;
        }
        int type = buff.readInt();
        switch (type) {
            case 1: {
                Entity entity;
                int entityID = buff.readInt();
                if (world == null || !((entity = world.func_73045_a(entityID)) instanceof EntityFishPufferfish)) break;
                ((EntityFishPufferfish)entity).scaredTime = buff.readInt();
                break;
            }
            case 2: {
                JAFFEventHandlerClient.enqueueSpawnHookPacket(buff);
                break;
            }
            case 3: {
                int entityID = buff.readInt();
                int hookID = buff.readInt();
                if (world == null) break;
                Entity entity = world.func_73045_a(entityID);
                Entity hookEntity = world.func_73045_a(hookID);
                if (!(hookEntity instanceof EntityIronFishHook)) break;
                ((EntityIronFishHook)hookEntity).hookEntity(entity);
                ((EntityIronFishHook)hookEntity).strain = 0;
                break;
            }
            case 4: {
                int itemID = buff.readInt();
                String handName = buff.func_150789_c(256);
                EnumHand hand = EnumHand.valueOf((String)handName);
                if (player == null || hand == null) break;
                player.func_184611_a(hand, ItemStack.field_190927_a);
                Item item = Item.func_150899_d((int)itemID);
                if (!(item instanceof ItemHookedFishingRod)) break;
                ((ItemHookedFishingRod)item).givePlayerBrokenScraps(player);
                break;
            }
            case 5: {
                int slot = buff.readInt();
                ItemStack item = ItemStack.field_190927_a;
                try {
                    item = buff.func_150791_c();
                }
                catch (IOException e) {
                    System.out.println("[JAFF] Caught an IOException! Uh oh!");
                    e.printStackTrace();
                }
                if (player == null) break;
                player.field_71071_by.func_70299_a(slot, item);
            }
        }
        return null;
    }
}

