/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.melter.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import knightminer.tcomplement.library.IHeaterConsumer;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.melter.inventory.ContainerHeater;
import knightminer.tcomplement.melter.tileentity.TileHeater;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.inventory.ContainerMultiModule;

public class GuiHeater
extends GuiMultiModule {
    public static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/heater.png");
    protected GuiElement flame = new GuiElementScalable(176, 0, 14, 14);
    public IHeaterConsumer consumer;

    public GuiHeater(ContainerHeater container, TileHeater heater) {
        super((ContainerMultiModule)container);
        this.consumer = container.getConsumer();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        float fuel;
        this.drawBackground(BACKGROUND);
        super.func_146976_a(partialTicks, mouseX, mouseY);
        if (this.consumer != null && (fuel = this.consumer.getFuelPercentage()) > 0.0f) {
            this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiElement flame = this.flame;
            int height = 1 + Math.round(fuel * (float)(flame.h - 1));
            int x = 81 + this.cornerX;
            int y = 36 + this.cornerY + flame.h - height;
            GuiScreen.func_146110_a((int)x, (int)y, (float)flame.x, (float)(flame.y + flame.h - height), (int)flame.w, (int)height, (float)flame.texW, (float)flame.texH);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.consumer != null && 81 <= (mouseX -= this.cornerX) && mouseX < 95 && 36 <= (mouseY -= this.cornerY) && mouseY < 50) {
            this.drawSolidFuelTooltip(mouseX, mouseY);
        }
    }

    protected void drawSolidFuelTooltip(int mouseX, int mouseY) {
        if (this.consumer.hasFuel()) {
            ArrayList text = Lists.newArrayList();
            text.add(TextFormatting.WHITE + Util.translate("gui.smeltery.fuel", new Object[0]));
            text.add(TextFormatting.GRAY + Util.translateFormatted("gui.tcomplement.melter.solid_fuel.amount", this.consumer.getFuel() / 5));
            this.func_146283_a(text, mouseX, mouseY);
        }
    }
}

