/*
 * Decompiled with CFR 0.152.
 */
package ru.poopycoders.improvedbackpacks.apiimpl;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import ru.poopycoders.improvedbackpacks.api.IBackpackItemFilter;
import ru.poopycoders.improvedbackpacks.api.ImprovedBackpacksApi;
import ru.poopycoders.improvedbackpacks.apiimpl.DefaultBlockedItems;

public class ImprovedBackpacksApiImpl
implements ImprovedBackpacksApi {
    private final List<IBackpackItemFilter> list = Lists.newArrayList();

    public ImprovedBackpacksApiImpl() {
        this.registerBlockedContent(new DefaultBlockedItems());
    }

    @Override
    public void registerBackpackItemFilter(IBackpackItemFilter filter) {
        if (!this.list.contains(filter)) {
            this.list.add(filter);
        }
    }

    public void registerBlockedContent(IBackpackItemFilter blockedContent) {
        if (!this.list.contains(blockedContent)) {
            this.list.add(blockedContent);
        }
    }

    public void unregisterBlockedContent(IBackpackItemFilter blockedContent) {
        this.list.remove(blockedContent);
    }

    public boolean isStackBlocked(ItemStack stack, @Nullable EntityPlayer player) {
        for (IBackpackItemFilter filter : this.list) {
            if (!filter.isStackBlocked(stack, player)) continue;
            return true;
        }
        return false;
    }
}

