/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mezz.jei.util.Log;

public final class FileUtil {
    private FileUtil() {
    }

    public static boolean writeFileSafely(File file, FileOperation fileOperation) {
        File fileNew = new File(file.getAbsolutePath());
        File fileBackup = new File(file.getAbsolutePath() + ".bak");
        File fileTemp = new File(file.getAbsolutePath() + ".tmp");
        try {
            if (fileTemp.exists() && !fileTemp.delete()) {
                throw new IOException("Could not delete old temp file");
            }
            fileOperation.handle(fileTemp);
            if (file.exists()) {
                if (fileBackup.exists() && !fileBackup.delete()) {
                    throw new IOException("Could not delete old backup");
                }
                if (!file.renameTo(fileBackup)) {
                    throw new IOException("Could not backup file");
                }
            }
            if (!fileTemp.renameTo(fileNew)) {
                throw new IOException("Could not rename temp file");
            }
            if (fileBackup.exists() && !fileBackup.delete()) {
                Log.get().error("Could not delete old backup file {}", (Object)fileBackup.getAbsoluteFile());
            }
            return true;
        }
        catch (IOException e) {
            Log.get().error("Failed to save file {}.", (Object)fileNew, (Object)e);
            if (fileBackup.exists()) {
                if ((!fileNew.exists() || fileNew.delete()) && fileBackup.renameTo(fileNew)) {
                    Log.get().info("Restored file from backup.");
                    return false;
                }
                Log.get().error("Failed to restore file from backup file {}", (Object)fileBackup.getAbsoluteFile());
            }
            return false;
        }
    }

    public static void readFileSafely(File file, FileOperation fileOperation) {
        File fileBackup;
        if (!file.exists() && (fileBackup = new File(file.getAbsolutePath() + ".bak")).exists() && fileBackup.renameTo(file)) {
            Log.get().info("Restored file from backup.");
        }
        if (file.exists()) {
            try {
                fileOperation.handle(file);
            }
            catch (IOException e) {
                Log.get().error("Failed to read file {}.", (Object)file, (Object)e);
            }
        }
    }

    public static void readZipFileSafely(File file, String zipEntryName, ZipInputFileOperation fileOperation) {
        FileUtil.readFileSafely(file, file1 -> {
            ZipInputStream zipInput = new ZipInputStream(new FileInputStream(file1));
            if (FileUtil.getZipEntry(zipInput, zipEntryName)) {
                fileOperation.handle(zipInput);
                zipInput.close();
            }
        });
    }

    public static boolean writeZipFileSafely(File file, String zipEntryName, ZipOutputFileOperation fileOperation) {
        return FileUtil.writeFileSafely(file, file1 -> {
            ZipOutputStream zipOutput = new ZipOutputStream(new FileOutputStream(file1));
            zipOutput.putNextEntry(new ZipEntry(zipEntryName));
            fileOperation.handle(zipOutput);
            zipOutput.closeEntry();
            zipOutput.close();
        });
    }

    public static boolean getZipEntry(ZipInputStream zipInputStream, String zipEntryName) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(zipEntryName)) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface ZipOutputFileOperation {
        public void handle(ZipOutputStream var1);
    }

    @FunctionalInterface
    public static interface ZipInputFileOperation {
        public void handle(ZipInputStream var1);
    }

    @FunctionalInterface
    public static interface FileOperation {
        public void handle(File var1) throws IOException;
    }
}

