/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.recipe;

import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.recipe.IColorLensChanger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.oredict.OreDictionary;

public class ColorLensRotator
implements IColorLensChanger {
    public static final Map<String, EnumDyeColor> STRING_TO_ENUM = new HashMap<String, EnumDyeColor>();
    final List<ItemStack> rotations;

    public ColorLensRotator(List<ItemStack> rotations) {
        this.rotations = rotations;
    }

    @Override
    public ItemStack modifyItem(ItemStack stack, IBlockState hitBlockState, BlockPos hitBlock, IAtomicReconstructor tile) {
        int idx = -1;
        for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
            EnumDyeColor color;
            String s = OreDictionary.getOreName((int)i);
            if (!s.startsWith("dye") || (color = STRING_TO_ENUM.get(s)) == null) continue;
            idx = color.func_176765_a();
            break;
        }
        if (idx == -1) {
            return ItemStack.field_190927_a;
        }
        ItemStack s = this.rotations.get((idx + 1) % this.rotations.size()).func_77946_l();
        s.func_190920_e(stack.func_190916_E());
        return s;
    }

    static {
        String[] dyes = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
        for (int i = 0; i < dyes.length; ++i) {
            STRING_TO_ENUM.put("dye" + dyes[i], EnumDyeColor.func_176764_b((int)i));
        }
    }
}

